% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_mod}
\alias{read_mod}
\title{Read Open ModPlug module}
\usage{
read_mod(file, ...)
}
\arguments{
\item{file}{File path or URL to read the file from. Binary connections are also supported.}

\item{...}{Ignored}
}
\value{
A \code{modplug} class object. It is an external pointer, pointing to the module object
in memory. It can be used for rendering audio.
}
\description{
Read any of the music tracker module file formats supported by libopenmpt:
\url{https://wiki.openmpt.org/Manual:_Module_formats}.
}
\examples{
## You can read from files
mod1 <- read_mod(system.file("cyberrid", "cyberrid.mod", package = "openmpt"))

\donttest{
## but also URLs
mod2 <- read_mod("https://api.modarchive.org/downloads.php?moduleid=41529#elektric_funk.mod")
}
}
