% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modarchive.R
\name{modarchive_info}
\alias{modarchive_info}
\alias{modarchive_search_mod}
\alias{modarchive_search_genre}
\alias{modarchive_search_hash}
\alias{modarchive_random}
\alias{modarchive_search_artist}
\alias{modarchive_view_by}
\alias{modarchive_download}
\alias{modarchive_api}
\alias{modarchive_requests}
\alias{modarchive_genres}
\title{Functions to interact with modArchive}
\usage{
modarchive_info(mod_id, api = modarchive_api())

modarchive_search_mod(
  text,
  where = c("filename_or_songtitle", "filename_and_songtitle", "filename", "songtitle",
    "module_instruments", "module_comments"),
  format = c("unset", "669", "AHX", "DMF", "HVL", "IT", "MED", "MO3", "MOD", "MTM",
    "OCT", "OKT", "S3M", "STM", "XM"),
  size,
  channels,
  page,
  api = modarchive_api()
)

modarchive_search_genre(
  genre = c("unset", modarchive_genres()),
  format = c("unset", "669", "AHX", "DMF", "HVL", "IT", "MED", "MO3", "MOD", "MTM",
    "OCT", "OKT", "S3M", "STM", "XM"),
  size,
  channels,
  page,
  api = modarchive_api()
)

modarchive_search_hash(text, api = modarchive_api())

modarchive_random(
  genre = modarchive_genres(),
  format = c("unset", "669", "AHX", "DMF", "HVL", "IT", "MED", "MO3", "MOD", "MTM",
    "OCT", "OKT", "S3M", "STM", "XM"),
  size,
  page,
  api = modarchive_api()
)

modarchive_search_artist(text, page, api = modarchive_api())

modarchive_view_by(
  text,
  by = c("view_by_list", "view_by_rating_comments", "view_by_rating_reviews",
    "view_modules_by_artistid", "view_modules_by_guessed_artist"),
  format = c("unset", "669", "AHX", "DMF", "HVL", "IT", "MED", "MO3", "MOD", "MTM",
    "OCT", "OKT", "S3M", "STM", "XM"),
  size,
  page,
  api = modarchive_api()
)

modarchive_download(mod_id, read_fun = read_mod, ...)

modarchive_api()

modarchive_requests(api = modarchive_api())

modarchive_genres()
}
\arguments{
\item{mod_id}{An \code{integer} code used as module identifier in the
ModArchive database. A \code{mod_id} can be obtained by performing a
search with for instance \code{modarchive_search_mod()}.}

\item{api}{Most ModArchive functions require a personal secret API key.
This key can be obtained from the ModArchive forum. See
\code{vignette("modarchive")} for more details.}

\item{text}{Text (\code{character}) used for searching. In some functions
the asterisk symbol \code{*} can be used as a wildcard in the search.}

\item{where}{A \code{character} string specifying where to search.
See the 'usage' section for allowed values.}

\item{format}{A \code{character} string specifying to which file format
the search should be limited. See 'usage' section for allowed values.}

\item{size}{A vector of two \code{integer} values, specifying a filter
to apply to the search results. It filters the results to the file size range
specified here in kB. When omitted, all file sizes are returned.}

\item{channels}{A vector of two \code{integer} values, specifying a filter
to apply to the search results. It filters the results to the specified range
of number of channels in the module. When omitted, modules with any
number of channels are returned.}

\item{page}{Many of the ModArchive functions return paginated tables.
When this argument is omitted, the first page is returned. Use an
\code{integer} value to return a specific page. The total number of pages
of a search or view is returned as an attribute to the returned
\code{data.frame}.}

\item{genre}{A genre of music to limit your search to. See
\code{modarchive_genres()} for a list of available values.}

\item{by}{A \code{character} string specifying which aspect to view the
results by. See the 'usage' section for allowed values.}

\item{read_fun}{Function that accepts an URL first argument.
By default it is \code{\link[=read_mod]{read_mod()}} and is used to read the file.
You can replace it with other functions such as \code{ProTrackR2::pt2_read_mod()}.}

\item{...}{Arguments passed on to \code{read_fun}}
}
\value{
Most functions documented here return a \code{data.frame}
with information about one or more modules, or an artist. \code{NULL}
is returned in case a search has no results.

\code{modarchive_download()} returns the result of calling \code{read_fun}
on the requested module.

\code{modarchive_requests()} returns the number of requests that
you made this month using the API key, and how many are available.

\code{modarchive_api()} returns your API key, when you have set it as
environmental variable (\code{"MODARCHIVE_API"}) or session option
(\code{"modarchive_api"}). When it is not set it will return \code{""}.

\code{modarchive_genres()} returns a vector of \code{character} strings,
listing the music genres specified by ModArchive.
}
\description{
\href{https://ModArchive.org}{ModArchive} is one of the largest online archives of module
files. These functions will assist in accessing this archive.
For mor information see \code{vignette("modarchive")}.
}
\examples{
elekfunk <- modarchive_download(41529)

## Check how many API requests are left this month
reqs <- modarchive_requests()
if (length(reqs) > 0) {
  reqs <- 1 - reqs$current / reqs$maximum
} else {
  reqs <- 0
}

## The examples below will only work with a valid
## API key for modArchive and if more than 25\%
## of the monthly requests are left:
if (modarchive_api() != "" && reqs > 0.25) {
  
  mod_info <- modarchive_info(41529)
  if (nrow(mod_info) > 0) mod_info$url[[1]]
  info_search <- modarchive_search_mod("*intro.mod",
                                       size = c(8L, 10L),
                                       channels = c(1L, 4L))
  info_genre  <- modarchive_search_genre("Chiptune", "IT")
  info_hash   <- modarchive_search_hash("8f80bcab909f700619025bd7f2975749")
  info_artist <- modarchive_search_artist("89200")
  info_list   <- modarchive_view_by("A", "view_by_list", "XM",
                                    page = 2)
  info_random <- modarchive_random("Comedy")
}
}
\seealso{
\code{\link[=modland_search]{modland_search()}}
}
