% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert_mod}
\alias{convert_mod}
\title{Convert a ModPlug Tracker module to an audio file}
\usage{
convert_mod(
  mod,
  file,
  start_order = 0L,
  start_row = 0L,
  sample_rate = 44100L,
  duration = NA_real_,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}}

\item{file}{Output audio file where the rendered audio is stored. The file name
extension is used to determine the type of encoding to be applied.}

\item{start_order}{Starting position (\code{integer} index starting at 0) in the pattern sequence table.}

\item{start_row}{Starting row (\code{integer} index starting at 0) of the pattern table.}

\item{sample_rate}{Output sample rate in Hz (samples per seconds).}

\item{duration}{Duration in seconds. Rendered sample will not be longer than this duration.
if set to \code{NA_real_} it is ignored and the module keeps rendering conform the specified \code{\link[=control]{control()}}.}

\item{verbose}{Passed on to \code{\link[av:encoding]{av::av_audio_convert()}}.}

\item{...}{Ignored}
}
\value{
Returns \code{NULL} invisibly
}
\description{
Renders ModPlug Tracker music to an audio file and encodes it to a desired
output format (e.g. .mp3, .ogg, etc) using \code{\link[av:encoding]{av::av_audio_convert()}}.
}
\examples{
mod <- demo_mod()

destination <- tempfile(fileext = ".mp3")

convert_mod(mod, destination, duration = 2)
}
