% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityPlot.R
\name{densityPlot}
\alias{densityPlot}
\title{Density plot}
\usage{
densityPlot(
  x,
  fact = NULL,
  bw = "nrd0",
  histo = c("none", "faded", "hollow"),
  breaks = "Sturges",
  fading = "0E",
  fadingBorder = "25",
  lty = NULL,
  lwd = 1,
  col = c("black", "red", "blue"),
  key = NULL,
  add = FALSE,
  adjust = 1,
  kernel = c("gaussian", "epanechnikov", "rectangular", "triangular", "biweight",
    "cosine", "optcosine"),
  weights = NULL,
  n = 512,
  from,
  to,
  na.rm = FALSE,
  xlim = NULL,
  ylim = NULL,
  main = "",
  ...
)
}
\arguments{
\item{x}{A numerical vector.}

\item{fact}{A character or factor vector defining the grouping for data in
\code{x}.}

\item{bw}{Bandwidth. See \code{density}.}

\item{histo}{Whether to plot a faded histogram (\code{'faded'}) or hollow
histogram (\code{'hollow'}) in the background. By default, no histogram will
be plotted.}

\item{breaks}{The \code{breaks} argument for histPlot if \code{histo} is
\code{'faded'} or \code{'hollow'}.}

\item{fading}{Character value of hexadecimal, e.g. \code{'22'} or
\code{'5D'}, describing the amount of fading inside the rectangles of the
histogram if \code{histo='faded'}.}

\item{fadingBorder}{Character value of hexadecimal, e.g. \code{'22'} or
\code{'5D'}, describing the amount of fading of the rectangle borders of the
histogram if \code{histo} is \code{'faded'} or \code{'hollow'}.}

\item{lty}{Numerical vector describing the line type for the density
curve(s). Each element corresponds to a different level of the
argument\code{fact}.}

\item{lwd}{Numerical vector describing the line width for the density
curve(s). Each element corresponds to a different level of the
argument\code{fact}.}

\item{col}{Numerical vector describing the line color for the density
curve(s). Each element corresponds to a different level of the
argument\code{fact}.}

\item{key}{An argument to specify ordering of the factor levels.}

\item{add}{If \code{TRUE}, the density curve is added to the plot.}

\item{adjust}{Argument passed to \code{density} to adjust the bandwidth.}

\item{kernel}{Argument passed to \code{density} to select the kernel used.}

\item{weights}{Argument passed to \code{density} to weight observations.}

\item{n}{Argument passed to \code{density} to specify the detail in the
density estimate.}

\item{from}{Argument passed to \code{density} specifying the lowest value to
include in the density estimate.}

\item{to}{Argument passed to \code{density} specifying the largest value to
include in the density estimate.}

\item{na.rm}{Argument passed to \code{density} specifying handling of
\code{NA} values.}

\item{xlim}{x-axis limits.}

\item{ylim}{y-axis limits.}

\item{main}{Title for the plot.}

\item{...}{If \code{add=FALSE}, then additional arguments to \code{plot}.}
}
\description{
Compute kernel density plots, written in the same structure as
\code{\link{boxPlot}}. Histograms can be automatically added for teaching
purposes.
}
\examples{

# hollow histograms
histPlot(tips$tip[tips$day == "Tuesday"],
  hollow = TRUE, xlim = c(0, 30),
  lty = 1, main = "Tips by day"
)
histPlot(tips$tip[tips$day == "Friday"],
  hollow = TRUE, border = "red",
  add = TRUE, main = "Tips by day"
)
legend("topright",
  col = c("black", "red"),
  lty = 1:2, legend = c("Tuesday", "Friday")
)

# density plots
densityPlot(tips$tip, tips$day,
  col = c("black", "red"), main = "Tips by day"
)
legend("topright",
  col = c("black", "red"),
  lty = 1:2, legend = c("Tuesday", "Friday")
)

densityPlot(tips$tip,
  histo = "faded",
  breaks = 15, main = "Tips by day"
)

densityPlot(tips$tip,
  histo = "hollow",
  breaks = 30, fadingBorder = "66",
  lty = 1, main = "Tips by day"
)
}
\seealso{
\code{\link{histPlot}}, \code{\link{dotPlot}},
\code{\link{boxPlot}}
}
\author{
David Diez
}
