% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa_fetch.R
\name{oa_fetch}
\alias{oa_fetch}
\title{A composition function to perform query building, requesting,
and convert the result to a tibble/data frame.}
\usage{
oa_fetch(
  entity = if (is.null(identifier)) NULL else id_type(identifier[[1]]),
  identifier = NULL,
  ...,
  search = NULL,
  sort = NULL,
  sample = NULL,
  seed = NULL,
  group_by = NULL,
  output = c("tibble", "dataframe", "list"),
  abstract = FALSE,
  endpoint = "https://api.openalex.org",
  per_page = 200,
  count_only = FALSE,
  mailto = oa_email(),
  verbose = FALSE
)
}
\arguments{
\item{entity}{Character. Scholarly entity of the search.
The argument can be one of c("works", "authors", "venues", "institutions", "concepts").
If not provided, `entity` is guessed from `identifier`.}

\item{identifier}{Character. OpenAlex ID(s) as item identifier(s).
See more at <https://docs.openalex.org/how-to-use-the-api/get-single-entities#the-openalex-id>.}

\item{...}{Additional filter arguments.}

\item{search}{Character. Search is just another kind of filter, one that all five endpoints support.
But unlike the other filters, search doesn't require an exact match.
To filter using search, append .search to the end of the attribute you're filtering for.}

\item{sort}{Character. Attribute to sort by.
For example: "display_name" for venues or "cited_by_count:desc" for works.
See more at <https://docs.openalex.org/how-to-use-the-api/get-lists-of-entities/sort-entity-lists>.}

\item{sample}{Integer. Number of (random) records to return.
Should be no larger than 10,000.
Defaults to NULL, which returns all records satisfying the query.
Read more at <https://docs.openalex.org/how-to-use-the-api/get-lists-of-entities/sample-entity-lists>.}

\item{seed}{Integer.
A seed value in order to retrieve the same set of random records in
the same order when used multiple times with `sample`.
IMPORTANT NOTE: Depending on your query, random results with a seed value may change over time due to new records coming into OpenAlex.
This argument is likely only useful when queries happen close together (within a day).}

\item{group_by}{Character. Attribute to group by.
For example: "oa_status" for works.
See more at <https://docs.openalex.org/how-to-use-the-api/get-groups-of-entities>.}

\item{output}{Character. Type of output, either a list or a tibble/data.frame.}

\item{abstract}{Logical. If TRUE, the function returns also the abstract of each item.
Default to \code{abstract = FALSE}.
The argument is ignored if entity is different from "works".}

\item{endpoint}{Character. URL of the OpenAlex Endpoint API server.
Defaults to endpoint = "https://api.openalex.org".}

\item{per_page}{Numeric. Number of items to download per page.
The per-page argument can assume any number between 1 and 200.
Defaults to 200.}

\item{count_only}{Logical.
If TRUE, the function returns only the number of item matching the query.
Defaults to FALSE.}

\item{mailto}{Character string.
Gives OpenAlex an email to enter the polite pool.}

\item{verbose}{Logical. If TRUE, print information on querying process.
Default to \code{verbose = FALSE}.}
}
\value{
A data.frame or a list. Result of the query.
}
\description{
A composition function to perform query building, requesting,
and convert the result to a tibble/data frame.
}
\examples{
\dontrun{

paper_meta <- oa_fetch(
  identifier = "W2755950973",
  entity = "works",
  count_only = TRUE,
  abstract = TRUE,
  verbose = TRUE
)

oa_fetch(
  entity = "works",
  doi = c(
    "10.1371/journal.pone.0266781",
    "10.1371/journal.pone.0267149"
  ),
  verbose = TRUE,
  count_only = TRUE
)

oa_fetch(
  entity = "works",
  doi = c(
    "10.1371/journal.pone.0266781",
    "10.1371/journal.pone.0267149"
  ),
  verbose = TRUE
)

oa_fetch(
  identifier = c("A923435168", "A2208157607"),
  verbose = TRUE
)
}
}
