% Generated by roxygen2 (4.0.1): do not edit by hand
\name{selectRunning}
\alias{selectRunning}
\title{Function to extract run lengths greater than a threshold}
\usage{
selectRunning(mydata, pollutant = "nox", run.len = 5, threshold = 500)
}
\arguments{
\item{mydata}{A data frame with a \code{date} field and at least one
numeric \code{pollutant} field to analyse.}

\item{pollutant}{Name of variable to process. Mandatory.}

\item{run.len}{Run length for extracting contiguous values of
\code{pollutant} above the \code{threshold} value.}

\item{threshold}{The threshold value for \code{pollutant} above which data
should be extracted.}
}
\value{
Returns a data frame that meets the chosen criteria. See examples
  below.
}
\description{
Utility function to extract user-defined run lengths (durations) above a
threshold
}
\details{
This is a utility function to extract runs of values above a certain
threshold. For example, for a data frame of hourly NOx values we would like
to extract all those hours where the concentration is at least 500ppb for
contiguous periods of 5 or more hours.

This function is useful, for example, for selecting pollution episodes from
a data frame i.e. where concentrations remain elevated for a certain period
of time. It may also be of more general use when analysing air pollution
data. For example, \code{selectRunning} could be used to extract continuous
periods of rainfall --- which could be important for particle
concentrations.
}
\examples{
## extract those hours where there are at least 5 consecutive NOx
## concentrations above 500ppb

mydata <- selectRunning(mydata, run.len = 5, threshold = 500)

## make a polar plot of those conditions...shows that those
## conditions are dominated by low wind speeds, not
## in-canyon recirculation
\dontrun{polarPlot(mydata, pollutant = "nox")}
}
\author{
David Carslaw
}
\keyword{methods}

