% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_engine.R
\name{retrieve_engine}
\alias{retrieve_engine}
\title{Retrieve engine}
\usage{
retrieve_engine(
  engine_id,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{engine_id}{required; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain information about the
engine.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\strong{Note:} This endpoint is deprecated and soon will be removed. Please use
its replacement,
\href{https://platform.openai.com/docs/api-reference/models}{Models}, instead. The
replacement function in this package is \code{retrieve_model()}.

Provides information about a specified engine. See \href{https://platform.openai.com/docs/api-reference/engines/retrieve}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://platform.openai.com/docs/api-reference/engines/retrieve}{official documentation}.
}
\examples{
\dontrun{
retrieve_engine("text-davinci-002")
# ->
retrieve_model("text-davinci-002")
}
}
\seealso{
Other engine functions: 
\code{\link{list_engines}()}
}
\concept{engine functions}
\keyword{internal}
