/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.doccat;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.doccat.TrainingParams;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoccatTrainerTool
extends AbstractTrainerTool<DocumentSample, TrainerToolParams> {
    public DoccatTrainerTool() {
        super(DocumentSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable document categorizer";
    }

    @Override
    public void run(String format, String[] args) {
        DoccatModel model;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("document categorizer model", modelOutFile);
        try {
            model = DocumentCategorizerME.train(((TrainerToolParams)this.params).getLang(), (ObjectStream<DocumentSample>)this.sampleStream, this.mlParams, new FeatureGenerator[0]);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("document categorizer", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

