/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;

public class IndexWordSet {
    private Map _indexWords = new Hashtable(4, 1.0f);
    private String _lemma;
    private transient String _cachedToString = null;

    public IndexWordSet(String lemma) {
        this._lemma = lemma;
    }

    public void add(IndexWord word) {
        this._indexWords.put(word.getPOS(), word);
    }

    public void remove(POS p) {
        this._indexWords.remove(p);
    }

    public int size() {
        return this._indexWords.size();
    }

    public IndexWord getIndexWord(POS p) {
        return (IndexWord)this._indexWords.get(p);
    }

    public IndexWord[] getIndexWordArray() {
        IndexWord[] words = new IndexWord[this._indexWords.size()];
        return this._indexWords.values().toArray(words);
    }

    public Collection getIndexWordCollection() {
        return this._indexWords.values();
    }

    public Set getValidPOSSet() {
        return this._indexWords.keySet();
    }

    public boolean isValidPOS(POS pos) {
        return this._indexWords.containsKey(pos);
    }

    public int getSenseCount(POS pos) {
        return this.getIndexWord(pos).getSenseCount();
    }

    public String toString() {
        if (this._cachedToString == null) {
            String str = "";
            if (this.size() == 0) {
                str = JWNL.resolveMessage("DATA_TOSTRING_003");
            } else {
                StringBuffer buf = new StringBuffer();
                Iterator itr = this.getValidPOSSet().iterator();
                while (itr.hasNext()) {
                    buf.append(this.getIndexWord((POS)itr.next()).toString());
                }
                str = buf.toString();
            }
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_004", str);
        }
        return this._cachedToString;
    }

    public String getLemma() {
        return this._lemma;
    }

    public boolean equals(Object object) {
        return object instanceof IndexWordSet && this.getLemma().equals(((IndexWordSet)object).getLemma());
    }
}

