/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;
import opennlp.tools.coref.resolver.ResolverUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluralNounResolver
extends MaxentResolver {
    public PluralNounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "plmodel", m, 80, true);
        this.showExclusions = false;
    }

    public PluralNounResolver(String projectName, ResolverMode m, NonReferentialResolver nrr) throws IOException {
        super(projectName, "plmodel", m, 80, true, nrr);
        this.showExclusions = false;
    }

    @Override
    protected List<String> getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(ResolverUtils.getContextFeatures(mention));
            features.addAll(ResolverUtils.getStringMatchFeatures(mention, entity));
        }
        return features;
    }

    @Override
    public boolean canResolve(MentionContext mention) {
        String firstTok = mention.getFirstTokenText().toLowerCase();
        String firstTokTag = mention.getFirstToken().getSyntacticType();
        boolean rv = mention.getHeadTokenTag().equals("NNS") && !ResolverUtils.definiteArticle(firstTok, firstTokTag);
        return rv;
    }

    @Override
    protected boolean excluded(MentionContext mention, DiscourseEntity entity) {
        if (super.excluded(mention, entity)) {
            return true;
        }
        MentionContext cec = entity.getLastExtent();
        return !cec.getHeadTokenTag().equals("NNS") || super.excluded(mention, entity);
    }
}

