/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import opennlp.maxent.ContextGenerator;
import opennlp.tools.util.Pair;

public class SDContextGenerator
implements ContextGenerator {
    private StringBuffer buf = new StringBuffer();
    private List collectFeats = new ArrayList();
    private Set inducedAbbreviations;
    private char[] eosCharacters;

    public SDContextGenerator(char[] eosCharacters) {
        this(Collections.EMPTY_SET, eosCharacters);
    }

    public SDContextGenerator(Set inducedAbbreviations, char[] eosCharacters) {
        this.inducedAbbreviations = inducedAbbreviations;
        this.eosCharacters = eosCharacters;
    }

    public String[] getContext(Object o) {
        String next;
        String suffix;
        String prefix;
        String previous;
        Object first = ((Pair)o).a;
        int position = (Integer)((Pair)o).b;
        if (first instanceof String[]) {
            String[] $_ = (String[])first;
            previous = $_[0];
            String current = $_[1];
            prefix = current.substring(0, position);
            suffix = current.substring(position + 1);
            if (suffix.startsWith(" ")) {
                this.collectFeats.add("sn");
            }
            if (prefix.endsWith(" ")) {
                this.collectFeats.add("pn");
            }
            this.collectFeats.add("eos=" + current.charAt(position));
            next = $_[2];
        } else {
            StringBuffer sb = (StringBuffer)((Pair)o).a;
            int lastIndex = sb.length() - 1;
            if (position > 0 && sb.charAt(position - 1) == ' ') {
                this.collectFeats.add("sp");
            }
            if (position < lastIndex && sb.charAt(position + 1) == ' ') {
                this.collectFeats.add("sn");
            }
            this.collectFeats.add("eos=" + sb.charAt(position));
            int prefixStart = SDContextGenerator.previousSpaceIndex(sb, position);
            int c = position;
            block0: while (--c > prefixStart) {
                int ecl = this.eosCharacters.length;
                for (int eci = 0; eci < ecl; ++eci) {
                    if (sb.charAt(c) != this.eosCharacters[eci]) continue;
                    prefixStart = c++;
                    continue block0;
                }
            }
            prefix = sb.substring(prefixStart, position).trim();
            int prevStart = SDContextGenerator.previousSpaceIndex(sb, prefixStart);
            previous = sb.substring(prevStart, prefixStart).trim();
            int suffixEnd = SDContextGenerator.nextSpaceIndex(sb, position, lastIndex);
            c = position;
            block2: while (++c < suffixEnd) {
                int ecl = this.eosCharacters.length;
                for (int eci = 0; eci < ecl; ++eci) {
                    if (sb.charAt(c) != this.eosCharacters[eci]) continue;
                    suffixEnd = c--;
                    continue block2;
                }
            }
            int nextEnd = SDContextGenerator.nextSpaceIndex(sb, suffixEnd + 1, lastIndex + 1);
            if (position == lastIndex) {
                suffix = "";
                next = "";
            } else {
                suffix = sb.substring(position + 1, suffixEnd).trim();
                next = sb.substring(suffixEnd + 1, nextEnd).trim();
            }
        }
        this.buf.append("x=");
        this.buf.append(prefix);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!prefix.equals("")) {
            this.collectFeats.add(Integer.toString(prefix.length()));
            if (SDContextGenerator.isFirstUpper(prefix)) {
                this.collectFeats.add("xcap");
            }
            if (this.inducedAbbreviations.contains(prefix)) {
                this.collectFeats.add("xabbrev");
            }
        }
        this.buf.append("v=");
        this.buf.append(previous);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!previous.equals("")) {
            if (SDContextGenerator.isFirstUpper(previous)) {
                this.collectFeats.add("vcap");
            }
            if (this.inducedAbbreviations.contains(previous)) {
                this.collectFeats.add("vabbrev");
            }
        }
        this.buf.append("s=");
        this.buf.append(suffix);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!suffix.equals("")) {
            if (SDContextGenerator.isFirstUpper(suffix)) {
                this.collectFeats.add("scap");
            }
            if (this.inducedAbbreviations.contains(suffix)) {
                this.collectFeats.add("sabbrev");
            }
        }
        this.buf.append("n=");
        this.buf.append(next);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!next.equals("")) {
            if (SDContextGenerator.isFirstUpper(next)) {
                this.collectFeats.add("ncap");
            }
            if (this.inducedAbbreviations.contains(next)) {
                this.collectFeats.add("nabbrev");
            }
        }
        String[] context = new String[this.collectFeats.size()];
        context = this.collectFeats.toArray(context);
        this.collectFeats.clear();
        return context;
    }

    private static final boolean isFirstUpper(String s) {
        return Character.isUpperCase(s.charAt(0));
    }

    private static final int previousSpaceIndex(StringBuffer sb, int seek) {
        --seek;
        while (seek > 0) {
            if (sb.charAt(seek) == ' ') {
                while (seek > 0 && sb.charAt(seek - 1) == ' ') {
                    --seek;
                }
                return seek;
            }
            --seek;
        }
        return 0;
    }

    private static final int nextSpaceIndex(StringBuffer sb, int seek, int lastIndex) {
        ++seek;
        while (seek < lastIndex) {
            char c = sb.charAt(seek);
            if (c == ' ' || c == '\n') {
                while (sb.length() > seek + 1 && sb.charAt(seek + 1) == ' ') {
                    ++seek;
                }
                return seek;
            }
            ++seek;
        }
        return lastIndex;
    }
}

