/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import opennlp.tools.ngram.DictionaryIterator;
import opennlp.tools.ngram.NGram;
import opennlp.tools.ngram.NGramFactory;
import opennlp.tools.util.NumberedSet;

public class Dictionary {
    public static String FILE_TYPE = "dict";
    protected NumberedSet wordMap;
    protected Set gramSet;
    protected int cutoff;
    protected NGramFactory nGramFactory;

    protected Dictionary() {
    }

    public Dictionary(String dictionaryFile) throws IOException {
        DataInputStream input = new DataInputStream(new GZIPInputStream(new FileInputStream(new File(dictionaryFile))));
        input.readUTF();
        int numWords = input.readInt();
        this.wordMap = new NumberedSet(numWords);
        for (int wi = 0; wi < numWords; ++wi) {
            String word = input.readUTF();
            int index = input.readInt();
            this.wordMap.setIndex(word, index);
        }
        this.loadGrams(input);
        this.nGramFactory = new NGramFactory(this.wordMap);
    }

    protected void loadGrams(DataInputStream input) throws IOException {
        this.gramSet = new HashSet();
        try {
            while (true) {
                int gramLength = input.readInt();
                int[] words = new int[gramLength];
                for (int wi = 0; wi < gramLength; ++wi) {
                    words[wi] = input.readInt();
                }
                this.gramSet.add(new NGram(words));
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public boolean contains(String[] words) {
        if (words.length == 1) {
            return this.wordMap.contains(words[0]);
        }
        NGram ngram = this.nGramFactory.createNGram(words);
        if (ngram == null) {
            return false;
        }
        return this.gramSet.contains(ngram);
    }

    public Iterator iterator() {
        return new DictionaryIterator(this);
    }

    public static void main(String[] args) throws IOException {
        String line;
        if (args.length == 0) {
            System.err.println("Usage: Dictionary dictionary_file");
            System.exit(0);
        }
        Dictionary dict = new Dictionary(args[0]);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (null != (line = in.readLine())) {
            String[] words = line.split(" ");
            if (dict.contains(words)) {
                System.out.println("Dictionary contains: " + line);
                continue;
            }
            System.out.println("Dictionary does not contain: " + line);
        }
    }
}

