/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import opennlp.maxent.DataStream;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;

public class NameFinderEventStream
implements EventStream {
    private DataStream data;
    private Event[] events;
    private NameContextGenerator cg;
    private Map prevTags;
    private int eventIndex;
    private String line;

    public NameFinderEventStream(DataStream d) {
        this(d, new DefaultNameContextGenerator());
    }

    public NameFinderEventStream(DataStream d, NameContextGenerator cg) {
        this.data = d;
        this.cg = cg;
        this.eventIndex = 0;
        this.prevTags = new HashMap();
        if (this.data.hasNext()) {
            this.line = (String)d.nextToken();
            if (this.line.equals("")) {
                this.prevTags.clear();
            } else {
                this.addEvents(this.line);
            }
        } else {
            this.events = new Event[0];
        }
    }

    private void addEvents(String sentence) {
        int ti;
        String[] parts = sentence.split(" ");
        String outcome = "other";
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> outcomes = new ArrayList<String>();
        int pl = parts.length;
        for (int pi = 0; pi < pl; ++pi) {
            if (parts[pi].equals("<START>")) {
                outcome = "start";
                continue;
            }
            if (parts[pi].equals("<END>")) {
                outcome = "other";
                continue;
            }
            toks.add(parts[pi]);
            outcomes.add(outcome);
            if (!outcome.equals("start")) continue;
            outcome = "cont";
        }
        this.events = new Event[toks.size()];
        int tl = toks.size();
        for (ti = 0; ti < tl; ++ti) {
            this.events[ti] = new Event((String)outcomes.get(ti), this.cg.getContext(ti, toks, outcomes, this.prevTags));
        }
        tl = toks.size();
        for (ti = 0; ti < tl; ++ti) {
            this.prevTags.put(toks.get(ti), outcomes.get(ti));
        }
    }

    public Event nextEvent() {
        if (this.eventIndex == this.events.length) {
            this.addEvents(this.line);
            this.eventIndex = 0;
            this.line = null;
        }
        return this.events[this.eventIndex++];
    }

    public boolean hasNext() {
        if (this.eventIndex < this.events.length) {
            return true;
        }
        if (this.line != null) {
            return true;
        }
        while (this.data.hasNext()) {
            this.line = (String)this.data.nextToken();
            if (this.line.equals("")) {
                this.prevTags.clear();
                continue;
            }
            return true;
        }
        return false;
    }

    public static final void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: NameFinderEventStream trainfiles");
            System.exit(1);
        }
        int al = args.length;
        for (int ai = 0; ai < al; ++ai) {
            NameFinderEventStream es = new NameFinderEventStream((DataStream)new PlainTextByLineDataStream((Reader)new FileReader(args[ai])));
            while (es.hasNext()) {
                System.out.println(es.nextEvent());
            }
        }
    }
}

