% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_export}
\alias{opal.table_export}
\title{Export a table as a file}
\usage{
opal.table_export(
  opal,
  project,
  table,
  file,
  identifiers = NULL,
  id.name = "id",
  wait = TRUE
)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table is located.}

\item{table}{Table name to export.}

\item{file}{Destination file in the Opal file system. The expected file extensions are: 
rds (RDS), sav (SPSS), zsav (SPSS compressed), sas7bdat (SAS), xpt (SAS Transport), 
dta (Stata).RDS (serialized single R object) is to be read by base::readRDS(), 
while other formats are supported by the haven R package.}

\item{identifiers}{Name of the identifiers mapping to use when exporting entities from Opal.}

\item{id.name}{The name of the column representing the entity identifiers. Default is 'id'.}

\item{wait}{Wait for import task completion. Default is TRUE.}
}
\description{
Export a table as file in the specified format. The file destination is in the Opal server 
file system. See \link{opal.file_download} to download the file locally. See also 
\link{opal.table_get} to get directly the table as an R object.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
cqx <- opal.table_export(o, "CNSIM", "CNSIM1", 
                         file = "/home/administrator/cnsim1.sav")
opal.logout(o)
}
}
