% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.file.r
\name{opal.file_rm}
\alias{opal.file_rm}
\title{Remove a file}
\usage{
opal.file_rm(opal, path)
}
\arguments{
\item{opal}{Opal object.}

\item{path}{Path to the file in the Opal file system.}
}
\description{
Remove a file or a folder from the Opal file system.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
# remove a file
opal.file_rm(o, '/home/administrator/export/some-data.csv')
# remove recursively a folder
opal.file_rm(o, '/home/administrator/export')
opal.logout(o)
}
}
\seealso{
Other file functions: 
\code{\link{opal.file_cp}()},
\code{\link{opal.file_download}()},
\code{\link{opal.file_ls}()},
\code{\link{opal.file_mkdir}()},
\code{\link{opal.file_mv}()},
\code{\link{opal.file_read}()},
\code{\link{opal.file_upload}()},
\code{\link{opal.file_write}()},
\code{\link{opal.file}()}
}
\concept{file functions}
