% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.r
\name{dsadmin.set_package_methods}
\alias{dsadmin.set_package_methods}
\title{Set DataSHIELD package methods}
\usage{
dsadmin.set_package_methods(opal, pkg, type = NULL)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{pkg}{Package name.}

\item{type}{Type of the method: "aggregate" or "assign". Default is NULL (=all type of methods).}
}
\value{
TRUE if successfull
}
\description{
Declare DataSHIELD aggregate and assign methods as defined by the package.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
dsadmin.set_package_methods(o, 'dsBase')
opal.logout(o)
}
}
\seealso{
Other DataSHIELD functions: \code{\link{dsadmin.get_methods}},
  \code{\link{dsadmin.get_method}},
  \code{\link{dsadmin.get_options}},
  \code{\link{dsadmin.install_package}},
  \code{\link{dsadmin.installed_package}},
  \code{\link{dsadmin.package_descriptions}},
  \code{\link{dsadmin.package_description}},
  \code{\link{dsadmin.remove_package}},
  \code{\link{dsadmin.rm_methods}},
  \code{\link{dsadmin.rm_method}},
  \code{\link{dsadmin.rm_option}},
  \code{\link{dsadmin.rm_package_methods}},
  \code{\link{dsadmin.set_method}},
  \code{\link{dsadmin.set_option}}
}
\concept{DataSHIELD functions}
