% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.r
\name{dsadmin.set_method}
\alias{dsadmin.set_method}
\title{Set DataSHIELD method}
\usage{
dsadmin.set_method(opal, name, func = NULL, path = NULL,
  type = "aggregate")
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{name}{Name of the method, as it will be accessed by DataSHIELD users.}

\item{func}{Function name.}

\item{path}{Path to the R file containing the script (mutually exclusive with func).}

\item{type}{Type of the method: "aggregate" (default) or "assign"}
}
\description{
Set DataSHIELD method
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
dsadmin.set_method(o, 'foo', 'base::mean')
opal.logout(o)
}
}
\seealso{
Other DataSHIELD functions: \code{\link{dsadmin.get_methods}},
  \code{\link{dsadmin.get_method}},
  \code{\link{dsadmin.get_options}},
  \code{\link{dsadmin.install_package}},
  \code{\link{dsadmin.installed_package}},
  \code{\link{dsadmin.package_descriptions}},
  \code{\link{dsadmin.package_description}},
  \code{\link{dsadmin.remove_package}},
  \code{\link{dsadmin.rm_methods}},
  \code{\link{dsadmin.rm_method}},
  \code{\link{dsadmin.rm_option}},
  \code{\link{dsadmin.rm_package_methods}},
  \code{\link{dsadmin.set_option}},
  \code{\link{dsadmin.set_package_methods}}
}
\concept{DataSHIELD functions}
