% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_pccs.R
\name{compare_hypotheses}
\alias{compare_hypotheses}
\title{Calculate the c-value of the difference in PCCs produced by two hypotheses}
\usage{
compare_hypotheses(m1, m2)
}
\arguments{
\item{m1}{an object of class "opafit" produced by a call to opa().}

\item{m2}{an object of class "opafit" produced by a call to opa().}
}
\value{
an object of class "opaHypothesisComparison".
}
\description{
Calculate the c-value of the difference in PCCs produced by two hypotheses
}
\examples{
dat <- data.frame(t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11),
                  t4 = c(10, 5, 11, 12))
h1 <- hypothesis(c(1, 2, 3, 4))
h2 <- hypothesis(c(1, 4, 2, 3))
opamod1 <- opa(dat, h1)
opamod2 <- opa(dat, h2)
compare_hypotheses(opamod1, opamod2)
}
