% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estMSE.R
\name{estMSE}
\alias{estMSE}
\title{Estimate MSE and its standard error}
\usage{
estMSE(
  y,
  x,
  fitFun,
  predFun,
  methodMSE,
  nFolds,
  nInnerFolds,
  cvReps,
  nBootstraps
)
}
\arguments{
\item{y}{The vector of outcome values}

\item{x}{The matrix of predictors}

\item{fitFun}{The function for fitting the prediction model}

\item{predFun}{The function for evaluating the prediction model}

\item{methodMSE}{The method to estimate the MSE, either "CV" for cross-validation or "bootstrap" for .632 bootstrap}

\item{nFolds}{The number of outer folds for cross-validation}

\item{nInnerFolds}{The number of inner cross-validation folds}

\item{cvReps}{The number of repeats for the cross-validation}

\item{nBootstraps}{The number of .632 bootstraps}
}
\value{
A vector with MSE estimate and its standard error
}
\description{
Estimate MSE and its standard error
}
\details{
The nested cross-validation scheme follows \insertCite{Bates2021}{oosse},
the .632 bootstrap is implemented as in \insertCite{Efron1997}{oosse}
}
\references{
\insertAllCited{}
}
