% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2oosse.R
\name{R2oosse}
\alias{R2oosse}
\title{Estimate the out-of-sample R² and its standard error}
\usage{
R2oosse(
  y,
  x,
  fitFun,
  predFun,
  methodMSE = c("CV", "bootstrap"),
  methodCor = c("nonparametric", "jackknife"),
  printTimeEstimate = TRUE,
  nFolds = 10L,
  nInnerFolds = nFolds - 1L,
  cvReps = 200L,
  nBootstraps = 200L,
  nBootstrapsCor = 50L,
  ...
)
}
\arguments{
\item{y}{The vector of outcome values}

\item{x}{The matrix of predictors}

\item{fitFun}{The function for fitting the prediction model}

\item{predFun}{The function for evaluating the prediction model}

\item{methodMSE}{The method to estimate the MSE, either "CV" for cross-validation or "bootstrap" for .632 bootstrap}

\item{methodCor}{The method to estimate the correlation between MSE and MST estimators, either "nonparametric" or "jackknife"}

\item{printTimeEstimate}{A boolean, should an estimate of the running time be printed?}

\item{nFolds}{The number of outer folds for cross-validation}

\item{nInnerFolds}{The number of inner cross-validation folds}

\item{cvReps}{The number of repeats for the cross-validation}

\item{nBootstraps}{The number of .632 bootstraps}

\item{nBootstrapsCor}{The number of bootstraps to estimate the correlation}

\item{...}{passed onto fitFun and predFun}
}
\value{
A list with components
\item{R2}{Estimate of the R² with standard error}
\item{MSE}{Estimate of the MSE with standard error}
\item{MST}{Estimate of the MST with standard error}
\item{corMSEMST}{Estimated correlation between MSE and MST estimators}
\item{params}{List of parameters used}
\item{fullModel}{The model trained on the entire dataset using fitFun}
}
\description{
Estimate the out-of-sample R² and its standard error
}
\details{
Implements the calculation of the R² and its standard error by \insertCite{Hawinkel2023}{oosse}.
 Multithreading is used as provided by the BiocParallel package,
A rough estimate of expected computation time is printed when prinTimeEstimate is true, but this is purely indicative.
The options to estimate the mean squared error (MSE) are cross-validation \insertCite{Bates2021}{oosse} or the .632 bootstrap \insertCite{Efron1997}{oosse}.
}
\examples{
data(Brassica)
#Linear model
fitFunLM = function(y, x){lm.fit(y = y, x = cbind(1, x))}
predFunLM = function(mod, x) {cbind(1,x) \%*\% mod$coef}
y = Brassica$Pheno$Leaf_8_width
R2lm = R2oosse(y = Brassica$Pheno$Leaf_8_width, x = Brassica$Expr[, 1:10],
fitFun = fitFunLM, predFun = predFunLM, nFolds = 5)
# A higher number of folds (e.g. 10) is recommended if computational resources allow
}
\references{
\insertAllCited{}
}
\seealso{
\link{buildConfInt}
}
