% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pcf_fast.R
\name{estimate_pcf_fast}
\alias{estimate_pcf_fast}
\title{estimate_pcf_fast}
\usage{
estimate_pcf_fast(pattern, ...)
}
\arguments{
\item{pattern}{Point pattern.}

\item{...}{Arguments passed down to `Kest` or `pcf.fv`.}
}
\value{
fv.object
}
\description{
Fast estimation of the pair correlation function
}
\details{
The functions estimates the pair correlation functions based on an estimation
of Ripley's K-function. This makes it computationally faster than estimating the
pair correlation function directly.

It is a wrapper around \code{Kest} and \code{pcf.fv} and returns a 'Function value
object' of the \code{spatstat} package.
}
\examples{
set.seed(42)
pattern <- spatstat.core::runifpoint(n = 100)
pcf_fast <- estimate_pcf_fast(pattern)

}
\references{
Ripley, B.D., 1977. Modelling spatial patterns. Journal of the Royal Statistical
Society. Series B (Methodological) 39, 172–192. https://doi.org/10.1111/j.2517-6161.1977.tb01615.x

Stoyan, D., Stoyan, H., 1994. Fractals, random shapes and point fields.
John Wiley & Sons, Chichester.
}
\seealso{
\code{\link{Kest}} \cr
\code{\link{pcf.fv}}
}
