% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-docs.R
\docType{package}
\name{onetime}
\alias{onetime}
\title{Run code only once}
\description{
Onetime allows package authors to run code only once (ever) for a given
user. It does so by writing a file, typically to a folder in the user's
configuration directory as given by \code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}. The
user can set an alternative filepath using \code{options("onetime.dir")}.
}
\details{
It is package authors' responsibility to check for permission
to store lockfiles. This may have been done already by another package if
onetime was already installed. You can ask permission interactively on
the command line by calling \code{\link[=check_ok_to_store]{check_ok_to_store()}} with \code{ask = TRUE}.

Core functions include:
\itemize{
\item \code{\link[=onetime_do]{onetime_do()}} runs arbitrary code only once.
\item \code{\link[=onetime_warning]{onetime_warning()}} and friends print a warning or message only once.
\item \code{\link[=onetime_message_confirm]{onetime_message_confirm()}} prints a message and asks
"Show this message again?"
\item \code{\link[=onetime_rlang_warn]{onetime_rlang_warn()}} and \code{\link[=onetime_rlang_inform]{onetime_rlang_inform()}} print messages using
functions from the rlang package.
\item \code{\link[=onetime_only]{onetime_only()}} returns a function that runs only once.
\item \code{\link[=check_ok_to_store]{check_ok_to_store()}} and \code{\link[=set_ok_to_store]{set_ok_to_store()}} check for or grant
permission to store lockfiles on the user's computer.
}

\subsection{Example}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(onetime)
ids  <- paste0("onetime-readme-", sample(1e9, 4))


for (i in 1:5) \{
  cat("Loop ", i, " of 5\n")
  onetime_do(cat("This command will only be run once.\n"), id = ids[1])
  onetime_warning("This warning will only be shown once.", id = ids[2])
  onetime_message("This message will only be shown once.", id = ids[3])
\}
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Loop  1  of 5
## This command will only be run once.

## Warning: This warning will only be shown once.

## This message will only be shown once.

## Loop  2  of 5
## Loop  3  of 5
## Loop  4  of 5
## Loop  5  of 5
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Meanwhile, in a separate process:
library(callr)
result <- callr::r(function (ids) \{
  onetime::onetime_message("This message with an existing ID will not be shown.", id = ids[1])
  onetime::onetime_message("This message with a new ID will be shown.", id = ids[4])
\}, show = TRUE, args = list(ids = ids))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## This message with an existing ID will not be shown.
## This message with a new ID will be shown.
}\if{html}{\out{</div>}}
}
}
