% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pop_query.R
\name{get_pop_query}
\alias{get_pop_query}
\title{Get Population Data}
\usage{
get_pop_query(token, data_type, planning_area, year, gender = NULL)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{data_type}{Type of data to be retrieved, should correspond to one of the API endpoints. E.g. to get economic status data, \code{data_type = "getEconomicStatus"}. The API endpoints can be found on the documentation page.}

\item{planning_area}{Town for which the data should be retrieved.}

\item{year}{Year for which the data should be retrieved.}

\item{gender}{Optional, if specified only records for that gender will be returned. This parameter is only valid for the \code{"getEconomicStatus"}, \code{"getEthnicGroup"}, \code{"getMaritalStatus"} and \code{"getPopulationAgeGroup"} endpoints. If specified for other endpoints, the parameter will be dropped.}
}
\value{
A tibble with 1 row and values for all the corresponding variables returned by the API endpoint.
If gender is not specified for endpoints with a gender parameter, records for total, male and female will be returned. The notable exception to this is for the \code{"getEthnicGroup"} endpoint, which only returns the total record if gender is not specified. This is because by default, this is the only API endpoint with a gender parameter that does not return gender breakdown by default.
If an error occurs, the function will return a NULL value
}
\description{
This function is a wrapper for the \href{https://docs.onemap.sg/#population-query}{Population Query API}. It only allows for querying of one data type (i.e. one of the API endpoints) for a particular town and year.
}
