% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_haplotypes.R
\name{plot.onemap_progeny_haplotypes_counts}
\alias{plot.onemap_progeny_haplotypes_counts}
\title{Plot recombination breakpoints counts for each individual}
\usage{
\method{plot}{onemap_progeny_haplotypes_counts}(x, by_homolog = FALSE, n.graphics = NULL, ncol = NULL, ...)
}
\arguments{
\item{x}{object of class onemap_progeny_haplotypes_counts}

\item{by_homolog}{logical, if TRUE plots counts by homolog (two for each individuals), if FALSE plots total counts by individual}

\item{n.graphics}{integer defining the number of graphics to be plotted, they separate the individuals in different plots}

\item{ncol}{integer defining the number of columns in plot}

\item{...}{currently ignored}
}
\value{
a ggplot graphic
}
\description{
Plot recombination breakpoints counts for each individual
}
\examples{
\donttest{
data("onemap_example_out")
twopts <- rf_2pts(onemap_example_out)
lg1 <- make_seq(twopts, 1:5)
lg1.map <- map(lg1)
prog.haplo <- progeny_haplotypes(lg1.map, most_likely = TRUE)
plot(progeny_haplotypes_counts(prog.haplo))
}

}
