% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dataset_bins.R
\name{create_data_bins}
\alias{create_data_bins}
\title{New dataset based on bins}
\usage{
create_data_bins(input.obj, bins)
}
\arguments{
\item{input.obj}{an object of class \code{onemap}.}

\item{bins}{an object of class \code{onemap_bin}.}
}
\value{
an object of class \code{onemap}.
}
\description{
Creates a new dataset based on \code{onemap_bin} object
}
\details{
Given a \code{onemap_bin} object,
creates a new data set where the redundant markers are
collapsed into bins and represented by the marker with the lower
amount of missing data among those on the bin.
}
\examples{
 \dontrun{
  load(url("https://github.com/mmollina/data/raw/master/fake_big_data_f2.RData"))
  fake.big.data.f2
  (bins <- find_bins(fake.big.data.f2, exact=FALSE))
  (new.data <- create_data_bins(fake.big.data.f2, bins))}
}
\seealso{
\code{\link[onemap]{find_bins}}
}
\author{
Marcelo Mollinari, \email{mmollina@usp.br}
}
\keyword{bins}
\keyword{dimension}
\keyword{reduction}
