% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-model.R
\name{add_variable}
\alias{add_variable}
\alias{add_variable_}
\title{Add a variable to the model}
\usage{
add_variable(.model, .variable, ..., type = "continuous", lb = -Inf, ub = Inf)

add_variable_(
  .model,
  .variable,
  ...,
  type = "continuous",
  lb = -Inf,
  ub = Inf,
  .dots
)
}
\arguments{
\item{.model}{the model}

\item{.variable}{the variable name/definition}

\item{...}{quantifiers for the indexed variable. Including filters}

\item{type}{must be either continuous, integer or binary}

\item{lb}{the lower bound of the variable}

\item{ub}{the upper bound of the variable}

\item{.dots}{Used to work around non-standard evaluation.}
}
\description{
A variable can either be a name or an indexed name. See examples.
}
\examples{
library(magrittr)
MIPModel() \%>\%
 add_variable(x) \%>\% # creates 1 variable named x
 add_variable(y[i], i = 1:10, i \%\% 2 == 0,
               type = "binary") # creates 4 variables

}
