% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-solution.R
\name{get_solution}
\alias{get_solution}
\alias{get_solution_}
\title{Get variable values from a solution}
\usage{
get_solution(solution, expr, type = "primal")

get_solution_(solution, expr, type)
}
\arguments{
\item{solution}{the solution object}

\item{expr}{a variable expression. You can partially bind indexes.}

\item{type}{optional, either "primal" or "dual". The default value is "primal".
If "primal" it returns the primal solution, otherwise the column duals.
Especially the dual values depend on the solver. If no duals are calculated,
the function stops with an error message.}
}
\value{
a data.frame. One row for each variable instance
        and a column for each index.
        Unless it is a single variable, then it returns a single number.
}
\description{
Get variable values from a solution
}
\examples{
\dontrun{
library(magrittr)
result <- MIPModel() \%>\%
     add_variable(x[i], i = 1:5) \%>\%
     add_variable(y[i, j], i = 1:5, j = 1:5) \%>\%
     add_constraint(x[i] >= 1, i = 1:5) \%>\%
     set_bounds(x[i], lb = 3, i = 1:3) \%>\%
     set_objective(0) \%>\%
     solve_model(with_ROI("glpk"))
solution <- get_solution(result, x[i])
solution2 <- get_solution(result, y[i, 1])
solution3 <- get_solution(result, y[i, j])
duals <- get_solution(result, x[i], type = "duals")
}

}
