% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearopt-variables.R
\name{colwise}
\alias{colwise}
\title{Format variables colwise}
\usage{
colwise(...)
}
\arguments{
\item{...}{create a colwise vector}
}
\description{
This function should be used if you to expand a variable
across columns and not rows. When passing a vector of indexes
to MILPModel variable, it creates a new row for each vector element.
With colwise you can create columns instead. Please see the examples
below.
}
\examples{
\dontrun{
  # vectors create matrix rows
  # x[1, 1]
  # x[2, 1]
  # x[3, 1]
  x[1:3, 1]

  # colwise() creates columns per row
  # 1 * x[1, 1] + 2 * x[1, 2] + 3 * x[1, 3]
  colwise(1, 2, 3) * x[1, colwise(1, 2, 3)]

  # you can also combine the two
  # x[1, 1]
  # x[2, 1] + x[2, 2]
  # x[3, 1] + x[3, 2] + x[3, 2]
  x[1:3, colwise(1, 1:2, 1:3)]
}
}
