% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classCdmReference.R
\name{collect.cdm_reference}
\alias{collect.cdm_reference}
\title{Retrieves the cdm reference into a local cdm.}
\usage{
\method{collect}{cdm_reference}(x, ...)
}
\arguments{
\item{x}{A cdm_reference object.}

\item{...}{For compatibility only, not used.}
}
\value{
A local cdm_reference.
}
\description{
Retrieves the cdm reference into a local cdm.
}
\examples{
\donttest{
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

cdm <- cdmFromTables(
  tables = list(
    "person" = dplyr::tibble(
      person_id = c(1, 2, 3), gender_concept_id = 0, year_of_birth = 1990,
      race_concept_id = 0, ethnicity_concept_id = 0
    ),
    "observation_period" = dplyr::tibble(
      observation_period_id = 1:3, person_id = 1:3,
      observation_period_start_date = as.Date("2000-01-01"),
      observation_period_end_date = as.Date("2023-12-31"),
      period_type_concept_id = 0
    )
  ),
  cdmName = "mock"
)

collect(cdm)
}
}
