% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_probability_vector.R
\name{check_probability_vector}
\alias{check_probability_vector}
\alias{assert_probability_vector}
\alias{test_probability_vector}
\title{Check probability vector}
\usage{
check_probability_vector(x, len = NULL, tolerance = sqrt(.Machine$double.eps))

assert_probability_vector(
  x,
  len = NULL,
  tolerance = sqrt(.Machine$double.eps),
  .var.name = checkmate::vname(x),
  add = NULL
)

test_probability_vector(x, len = NULL, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{tolerance}{[\code{numeric(1)}]\cr
A non-negative tolerance value.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}
}
\value{
Same as documented in \code{\link[checkmate]{check_numeric}}.
}
\description{
These functions check whether the input fulfills the properties of a
probability matrix.
}
\examples{
p <- c(0.2, 0.3, 0.6)
check_probability_vector(p)
test_probability_vector(p)
\dontrun{
assert_probability_vector(p)
}
}
\seealso{
Other vector helpers: 
\code{\link{check_numeric_vector}()},
\code{\link{chunk_vector}()},
\code{\link{insert_vector_entry}()},
\code{\link{map_indices}()},
\code{\link{match_numerics}()},
\code{\link{permutations}()},
\code{\link{split_vector_at}()},
\code{\link{subsets}()},
\code{\link{vector_occurrence}()}
}
\concept{vector helpers}
\keyword{validation}
