% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/dirichlet.R
\name{ddirichlet_cpp}
\alias{ddirichlet_cpp}
\alias{rdirichlet_cpp}
\alias{ddirichlet}
\alias{rdirichlet}
\title{Dirichlet distribution}
\usage{
ddirichlet_cpp(x, concentration, log = FALSE)

rdirichlet_cpp(concentration)

ddirichlet(x, concentration, log = FALSE)

rdirichlet(n = 1, concentration)
}
\arguments{
\item{x}{[\code{numeric()}]\cr
A probability vector.}

\item{concentration}{[\code{numeric()}]\cr
A concentration vector of the same length as \code{x}.}

\item{log}{[\code{logical(1)}]\cr
Return the logarithm of the density value?}

\item{n}{[\code{integer(1)}]\cr
The number of samples.}
}
\value{
For \code{ddirichlet()}: The density value.

For \code{rdirichlet()}: If \code{n = 1} a \code{vector} of length \code{p}, else
a \code{matrix} of dimension \code{n} times \code{p} with samples as rows.
}
\description{
The function \code{ddirichlet()} computes the density of a Dirichlet distribution.

The function \code{rdirichlet()} samples from a Dirichlet distribution.

The functions with suffix \verb{_cpp} perform no input checks, hence are faster.
}
\examples{
x <- c(0.5, 0.3, 0.2)
concentration <- 1:3

# compute density
ddirichlet(x = x, concentration = concentration)
ddirichlet(x = x, concentration = concentration, log = TRUE)

# sample
rdirichlet(concentration = 1:3)
rdirichlet(n = 4, concentration = 1:2)
}
\seealso{
Other simulation helpers: 
\code{\link{correlated_regressors}()},
\code{\link{dmvnorm_cpp}()},
\code{\link{dtnorm_cpp}()},
\code{\link{dwishart_cpp}()},
\code{\link{simulate_markov_chain}()}
}
\concept{simulation helpers}
\keyword{distribution}
