% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_occurrence.R
\name{vector_occurrence}
\alias{vector_occurrence}
\title{Find the positions of first or last occurrence of unique vector elements}
\usage{
vector_occurrence(x, type = "first")
}
\arguments{
\item{x}{A \code{vector}.}

\item{type}{Either \code{"first"} for the first or \code{"last"} for the last occurrence.}
}
\value{
An \code{integer} \code{vector}, the positions of the unique vector elements.
The ordering corresponds to \code{unique(x)}, i.e., the \eqn{i}-th element in
the output is the (first or last) occurrence of the \eqn{i}-th element from
\code{unique(x)}.
}
\description{
This function finds the positions of first or last occurrence of unique
vector elements.
}
\examples{
x <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
unique(x)
vector_occurrence(x, "first")
vector_occurrence(x, "last")
}
