% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.2.221.R
\name{od.2.221}
\alias{od.2.221}
\title{Optimal sample allocation calculation for two-level CRTs probing
    mediation effects with cluster-level mediators}
\usage{
od.2.221(
  a = NULL,
  b = NULL,
  n = NULL,
  p = NULL,
  icc = NULL,
  c1 = NULL,
  c1t = NULL,
  c2 = NULL,
  c2t = NULL,
  m = NULL,
  r2m = 0,
  r.yx = 0,
  r.mw = 0,
  r.yw = 0,
  q.a = 0,
  q.b = 0,
  test = "joint",
  tol = 1e-11,
  power = 0.8,
  d.p = c(0.1, 0.5),
  d.n = c(2, 100),
  sig.level = 0.05,
  two.tailed = TRUE,
  Jlim = c(max(q.a, q.b) + 4, 1e+06),
  verbose = TRUE,
  nrange = c(1.5, 10000),
  max.value = Inf,
  max.iter = 300,
  e = 1e-10,
  n.of.ants = 10,
  n.of.archive = 50,
  q = 1e-04,
  xi = 0.5
)
}
\arguments{
\item{a}{The treatment effect on the mediator.}

\item{b}{The within treatment correlation between the outcome and
the mediator at the cluster level.}

\item{n}{The level-1 sample size per level-2 unit.}

\item{p}{The proportion of level-2 clusters/units to be assigned to treatment.}

\item{icc}{The unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{c2}{The cost of sampling one level-2 unit in control condition.}

\item{c2t}{The cost of sampling one level-2 unit in treatment condition.}

\item{m}{Total budget.}

\item{r2m}{The proportion of mediator variance explained by covariates in
the mediator model.}

\item{r.yx}{The correlation between the outcome and the covariate at the
individual level.}

\item{r.mw}{The correlation between the mediator and the covariate at the
cluster level.}

\item{r.yw}{The correlation between the outcome and the covariate at the
cluster level.}

\item{q.a}{The number of covariates in the mediator model
(except the treatment indicator).}

\item{q.b}{The  number of covariates in the outcome model
at the cluster level
(except the treatment indicator and the mediator).}

\item{test}{The type of test will be used to detect mediation effects.
Default is the joint significance test (i.e., test = "joint").
The other choice is the Sobel test
by specifying the argument as test = "sobel".}

\item{tol}{convergence tolerance.}

\item{power}{Statistical power specified. The default value is .80.}

\item{d.p}{The initial sampling domains for p. Default is c(0.1, 0.5).}

\item{d.n}{The initial sampling domain for n. Default is c(2, 100).}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Two tailed test, the default value is TRUE.}

\item{Jlim}{The range for J to solve for a numerical solution.
Default is c(max(q.a, q.b)+4, 1e6).}

\item{verbose}{Print out evaluation process if TRUE, default is TRUE.}

\item{nrange}{The range of the individual-level sample size per cluster
that used to exclude unreasonable values. Default value is c(1.5, 10000).}

\item{max.value}{Maximal value of optimization when used as
the stopping criterion. Default is -Inf.}

\item{max.iter}{Maximal number of function evaluations when used as
the stopping criterion.}

\item{e}{Maximum error value used when solution quality used as
the stopping criterion, default is 1e-10.}

\item{n.of.ants}{Number of ants used in each iteration after the initialization
of power analysis for calculating required budget, default value is 10.}

\item{n.of.archive}{Size of the solution archive, default is 100.}

\item{q}{Locality of the search (0,1), default is 0.0001.}

\item{xi}{Convergence pressure (0, Inf), suggested: (0, 1), default is 0.5.}
}
\value{
Unconstrained or constrained optimal sample allocation
    (\code{n} and \code{p}).
    The function also returns the variance of a mediation effect
    or statistical power,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of two-level
    cluster randomized trials (CRTs) probing mediation effects with
    cluster-level mediators is to to identify
    the optimal sample allocation that requires the minimum budget
    to achieve certain power level.
    The optimal design parameters include
    the level-1 sample size per level-2 unit (\code{n})
    and the proportion of level-2 clusters/groups to be assigned to
    treatment (\code{p}).
    This function solves the optimal \code{n} and/or \code{p}
    with and without a constraint.
}
