% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.4m.R
\name{power.4m}
\alias{power.4m}
\title{Budget and/or sample size, power, MDES calculation for four-level multisite randomized trials}
\usage{
power.4m(cost.model = TRUE, expr = NULL, constraint = NULL,
  sig.level = 0.05, two.tailed = TRUE, d = NULL, power = NULL,
  m = NULL, n = NULL, J = NULL, K = NULL, L = NULL, p = NULL,
  icc2 = NULL, icc3 = NULL, icc4 = NULL, r12 = NULL, r22 = NULL,
  r32 = NULL, r42m = NULL, q3 = NULL, q4 = NULL, c1 = NULL,
  c2 = NULL, c3 = NULL, c4 = NULL, c1t = NULL, c2t = NULL,
  c3t = NULL, omega = NULL, dlim = NULL, powerlim = NULL,
  Llim = NULL, mlim = NULL, rounded = TRUE)
}
\arguments{
\item{cost.model}{logical; power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, otherwise conventional power analyses
(e.g., required sample size, power, or MDES calculation); default value is TRUE.}

\item{expr}{returned objects from function \code{\link{od.4m}}; default is NULL;
if \code{expr} is specified, parameter values of \code{icc2}, \code{icc3}, \code{icc4},
\code{r12}, \code{r22}, \code{r32}, \code{r42m},
\code{c1}, \code{c2}, \code{c3}, \code{c4},
\code{c1t}, \code{c2t}, \code{c3t}, \code{p}, \code{n}, \code{J}, and \code{K}
used or solved in function \code{\link{od.4m}} will
be passed to current function;
only the values of \code{p}, \code{n}, \code{J}, and/or \code{K} that specified or solved in
function \code{\link{od.4m}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{specify the constrained values of \code{p}, \code{n}, \code{J},
and/or \code{K} in list format to overwrite
those from \code{expr}; default value is NULL.}

\item{sig.level}{significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{d}{effect size.}

\item{power}{statistical power.}

\item{m}{total budget.}

\item{n}{the level-1 sample size per level-2 unit.}

\item{J}{the level-2 sample size per level-3 unit.}

\item{K}{the level-3 sample size per level-4 unit.}

\item{L}{the total level-4 sample size.}

\item{p}{the proportion of level-3 units to be assigned to treatment.}

\item{icc2}{the unconditional intraclass correlation coefficient (ICC) at level 2.}

\item{icc3}{the unconditional intraclass correlation coefficient (ICC) at level 3.}

\item{icc4}{the unconditional intraclass correlation coefficient (ICC) at level 4.}

\item{r12}{the proportion of level-1 variance explained by covariates.}

\item{r22}{the proportion of level-2 variance explained by covariates.}

\item{r32}{the proportion of level-3 variance explained by covariates.}

\item{r42m}{the proportion of variance of site-specific treatment effect explained by covariates.}

\item{q3}{the number of covariates at level 3.}

\item{q4}{the number of covariates at level 4.}

\item{c1}{the cost of sampling one level-1 unit in control condition.}

\item{c2}{the cost of sampling one level-2 unit in control condition.}

\item{c3}{the cost of sampling one level-3 unit in control condition.}

\item{c4}{the cost of sampling one level-4 unit.}

\item{c1t}{the cost of sampling one level-1 unit in treatment condition.}

\item{c2t}{the cost of sampling one level-2 unit in treatment condition.}

\item{c3t}{the cost of sampling one level-3 unit in treatment condition.}

\item{omega}{the standardized variance of site-specific treatment effect}

\item{dlim}{the range for searching the root of effect size (\code{d}) numerically,
default value is c(0, 5).}

\item{powerlim}{the range for searching the root of power (\code{power}) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{Llim}{the range for searching the root of level-4 sample size (\code{L}) numerically,
default value is c(4, 1e+10).}

\item{mlim}{the range for searching the root of budget (\code{m}) numerically,
default is the costs sampling \code{Llim} level-4 units
or c(4 * Lcost, 1e+10 * Lcost) with Lcost =
((1 - p) * (c1 * n * J * K + c2 * J * K + c3 * K) +
p * (c1t * n * J * K + c2t * J * K + c3t * K) + c4.}

\item{rounded}{logical; round the values of \code{p}, \code{n}/\code{J}/\code{K}
that are from functions \code{\link{od.4}}
to two decimal places and integer, respectively if TRUE,
otherwise no rounding; default value is TRUE.}
}
\value{
Required budget (and/or required level-4 sample size), statistical power, or MDES
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power,
    power or minimum detectable effect size (MDES) under fixed budget
    for four-level multisite randomized trials (MRTs).
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDES calculation).
}
\examples{
# unconstrained optimal design #---------
  myod1 <- od.4m(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05, omega = 0.02,
              r12 = 0.5, r22 = 0.5, r32 = 0.5, r42m = 0.5,
              c1 = 1, c2 = 5, c3 = 25,
              c1t = 1, c2t = 50, c3t = 250, c4 = 500,
              varlim = c(0, 0.005))
  myod1$out # n = 8.3, J = 3.2, K = 4.9, p = 0.36

# ------- power analyses by default considering costs and budget -------
# required budget and sample size
  mym.1 <- power.4m(expr = myod1, d = 0.2, q3 = 1, q4 = 1, power = 0.8)
  mym.1$out  # m = 28668, L = 19.5
  # mym.1$par  # parameters and their values used for the function
# or equivalently, specify every argument in the function
  mym.1 <- power.4m(d = 0.2, power = 0.8, q3 = 1, q4 = 1,
                 icc2 = 0.2, icc3 = 0.1, icc4 = 0.05, omega = 0.02,
                 r12 = 0.5, r22 = 0.5, r32 = 0.5, r42m = 0.5,
                 c1 = 1, c2 = 5, c3 = 25,
                 c1t = 1, c2t = 50, c3t = 250, c4 = 500,
                 n = 8, J = 3, K = 5, p = 0.36)
# required budget and sample size with constrained p
  mym.2 <- power.4m(expr = myod1, d = 0.2, q3 = 1, q4 = 1, power = 0.8,
                 constraint = list(p = 0.5))
  mym.2$out  # m = 31379, L = 18.2
# required budget and sample size with constrained p and n
  mym.3 <- power.4m(expr = myod1, d = 0.2, q3 = 1, q4 = 1, power = 0.8,
                 constraint = list(p = 0.5, n = 20))
  mym.3$out  # m = 32257, L = 17.0

# Power calculation
  mypower <- power.4m(expr = myod1, q3 = 1, q4 = 1, d = 0.2, m = 28668)
  mypower$out  # power = 0.80
# Power calculation under constrained p (p = 0.5)
  mypower.1 <- power.4m(expr = myod1, q3 = 1, q4 = 1, d = 0.2, m = 28668,
                 constraint = list(p = 0.5))
  mypower.1$out  # power = 0.76

# MDES calculation
  mymdes <- power.4m(expr = myod1, q3 = 1, q4 = 1, power = 0.80, m = 28668)
  mymdes$out  # d = 0.20


# ------- conventional power analyses with cost.model = FALSE-------
# Required sample size
  myL <- power.4m(cost.model = FALSE, expr = myod1, d = 0.2, q3 = 1, q4 = 1, power = 0.8)
  myL$out  # L = 19.5
  # myL$par  # parameters and their values used for the function
# or equivalently, specify every argument in the function
  myL <- power.4m(cost.model = FALSE, d = 0.2, power = 0.8, q3 = 1, q4 = 1,
                  icc2 = 0.2, icc3 = 0.1, icc4 = 0.05, omega = 0.02,
                 r12 = 0.5, r22 = 0.5, r32 = 0.5, r42m = 0.5,
                 c1 = 1, c2 = 5, c3 = 25,
                 c1t = 1, c2t = 50, c3t = 250, c4 = 500,
                 n = 8, J = 3, K = 5, p = 0.36)

# Power calculation
  mypower1 <- power.4m(cost.model = FALSE, expr = myod1, L = 19.5, d = 0.2, q3 = 1, q4 = 1)
  mypower1$out  # power = 0.80

# MDES calculation
  mymdes1 <- power.4m(cost.model = FALSE, expr = myod1, L = 19.5, power = 0.8, q3 = 1, q4 = 1)
  mymdes1$out  # d = 0.20

}
\references{
Shen, Z. (in progress). Using optimal sample allocation to
  improve statistical precision and design efficiency for multilevel randomized trials
  (Unpublished doctoral dissertation). University of Cincinnati, Cincinnati, OH.
}
