% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_remote.R
\name{pull_remote}
\alias{pull_remote}
\title{pull_remote}
\usage{
pull_remote(target = "", briefcase = "odkBriefcase_latest", id, to = "",
  from = "", username, password)
}
\arguments{
\item{target}{Path to directory of ODK Briefcase \code{.jar} file. Directory
path should match directory path used when calling \code{get_briefcase()}.
If ODK Briefcase \code{.jar} file was downloaded manually from \url{https://opendatakit.org},
\code{target} should match the directory path where \code{.jar} file has
been downloaded into.}

\item{briefcase}{Filename of the downloaded ODK Briefcase \code{.jar} file.
Default is \code{odkBriefcase_latest} to match the default filename used
by \code{get_briefcase()}. If ODK Briefcase \code{.jar} file was
downloaded manually from \url{https://opendatakit.org}, filename should
match the default filename used by Open Data Kit which is usually
"ODK Briefcase vX.Y.Z Production.jar" where vX.Y.Z is the version number}

\item{id}{Form ID of form to be pulled}

\item{to}{Destination directory for pulled ODK forms}

\item{from}{URL of remote ODK Aggregate server}

\item{username}{Username for account in remote ODK Aggregate server from
which forms are to be pulled}

\item{password}{Password for account in remote ODK Aggregate server from
which forms are to be pulled}
}
\value{
Folder in destination directory named "ODK Briefcase Storage"
containing forms pulled from remote ODK Aggregate server
}
\description{
Pull ODK forms from remote ODK Aggregate via ODK Briefcase
}
\examples{
  # Use latest ODK Briefcase (version 1.8,0) and connect to a test
  # remote ODK Aggregate server from ONA (https://ona.io); pulled forms to
  # be saved in default location at current working directory
  \dontrun{
  dirPath <- tempdir()
  get_briefcase(destination = dirPath)
  pull_remote(target = dirPath,
              id = "stakeholders",
              from = "https://ona.io/validtrial",
              to = dirPath,
              username = "validtrial",
              password = "zEF-STN-5ze-qom")
  }
}
