% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/or_function.R
\name{odds.n.ends}
\alias{odds.n.ends}
\title{A logistic regression function}
\usage{
odds.n.ends(x)
}
\arguments{
\item{x}{is a glm object}
}
\description{
This function allows you to compute model
significance (model chi-squared), model fit (percent
correctly predicted), and odds ratios with 95 percent confidence
intervalS for
a glm object from a logistic regression analysis.
}
\examples{
sick <- c(0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1)
age <- c(23, 25, 26, 34, 54, 46, 48, 95, 81, 42, 62, 25, 31, 49, 57, 52, 54, 63, 61, 50)
logisticModel <- glm(sick ~ age, na.action = na.exclude, family = binomial(logit))
odds.n.ends(logisticModel)
}
\keyword{fit}
\keyword{glm}
\keyword{logistic}
\keyword{odds}
