% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odbc-connection.R
\name{odbcConnectionColumns}
\alias{odbcConnectionColumns}
\title{odbcConnectionColumns}
\usage{
odbcConnectionColumns(conn, name, ..., exact = FALSE)
}
\arguments{
\item{conn}{OdbcConnection}

\item{name}{Table identifiers.
By default, are interpreted as a ODBC search pattern where \verb{_} and \verb{\%} are
wild cards. Set \code{exact = TRUE} to match \verb{_} exactly.}

\item{...}{additional parameters to methods}

\item{exact}{Set to \code{TRUE} to escape \verb{_} in identifier names so that it
matches exactly, rather than matching any single character. \verb{\%} always
matches any number of characters as this is unlikely to appear in a
table name.}
}
\value{
data.frame with columns
\itemize{
\item name
\item field.type - equivalent to type_name in SQLColumns output
\item table_name
\item schema_name
\item catalog_name
\item data_type
\item column_size
\item buffer_length
\item decimal_digits
\item numeric_precision_radix
\item remarks
\item column_default
\item sql_data_type
\item sql_datetime_subtype
\item char_octet_length
\item ordinal_position
\item nullable
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function has been deprecated in favor of \code{\link[DBI:dbListFields]{DBI::dbListFields()}}.

For a given table this function returns detailed information on
all fields / columns.  The expectation is that this is a relatively thin
wrapper around the ODBC \code{SQLColumns} function call, with some of the field
names renamed / re-ordered according to the return specifications below.
}
\details{
In \code{\link[DBI:dbWriteTable]{DBI::dbWriteTable()}} we make a call to this method
to get details on the fields of the table we are writing to.  In particular
the columns \code{data_type}, \code{column_size}, and \code{decimal_digits} are used.  An
implementation is not necessary for \code{\link[DBI:dbWriteTable]{DBI::dbWriteTable()}} to work.

\code{odbcConnectionColumns} is routed through the \code{SQLColumns} ODBC
method.  This function, together with remaining catalog functions
(\code{SQLTables}, etc), by default ( \code{SQL_ATTR_METADATA_ID == false} ) expect
either ordinary arguments (OA) in the case of the catalog, or pattern value
arguments (PV) in the case of schema/table name.  For these, quoted
identifiers do not make sense, so we unquote identifiers prior to the call.
}
\seealso{
The ODBC documentation on
\href{https://learn.microsoft.com/en-us/sql/odbc/reference/syntax/sqlcolumns-function}{SQLColumns}
for further details.
}
\keyword{internal}
