% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocsManager.R
\docType{class}
\name{ocsManager}
\alias{ocsManager}
\title{ocsManager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ocsManager
}
\description{
ocsManager
}
\section{General Methods}{

\describe{
 \item{\code{new(url, user, pwd, logger)}}{
   This method is used to instantiate an ocsManager. The user/pwd are
   mandatory in order to connect to 'ocs'. The logger can be either
   NULL, "INFO" (with minimum logs), or "DEBUG" (for complete curl 
   http calls logs)
 }
 \item{\code{connect()}}{
   A method to connect to 'ocs' and set version/capabilities
 }
 \item{\code{getVersion()}}{
   Get the 'ocs' server version
 }
 \item{\code{getCapabilities()}}{
   Get the 'ocs' server capabilities
 }
 \item{\code{getWebdavRoot()}}{
   Get the 'ocs' WebDAV root URL
 }
}
}

\section{WebDAV methods}{

\describe{
 \item{\code{listFiles(relPath)}}{
   WebDAV method to list folders/files given a relative path. The relative path is set
   to \code{"/"} by default, which corresponds to the root of the 'ocs' repository.
 }
 \item{\code{makeCollection(name, relPath)}}{
   WebDAV method to make a collection. By default \code{relPath} is set to \code{"/"} (root).
   The \code{name} is the name of the new collection to be created. The function is recursive
   in the sense that a \code{name} can be provided as relative path of a collection tree 
   (eg \code{newfolder1/newfolder2/newfolder3}), the function will create recursively as 
   many collections are handled in the name. 
 }
 \item{\code{uploadFile(filename, relPath)}}{
   WebDAV method to upload a file. By default \code{relPath} is set to \code{"/"} (root).
 }
}
}

\section{'OCS' Share API methods}{

\describe{
 \item{\code{getShares(path, reshares, shared_with_me, state, subfiles, pretty)}}{
   Get list of shares as \code{list}. To return as \code{data.frame}, set 
   \code{pretty = TRUE}. The method accepts additional parameters. 
 }
 \item{\code{createShare(path, name, shareType, shareWith, publicUpload, password, 
 permissions = NULL, expireDate = NULL)}}{
   Creates a share for the path (file or folder), given a name. The \code{shareType} should be among
   values 'user','group','publiclink' or 'federated'.The \code{shareWith} is required for \code{shareType} 
   'user' and 'group' and corresponds to the username or groupname. The \code{permissions} can be set among
   values 'read', 'update', 'create', 'delete', 'read-write', 'share', 'all'. By default the permissions will 
   be the default permissions set by the ocs server (by default 'all').
 }
 \item{\code{shareWithUser(path, name, username, permissions, pretty)}}{
  Shares a resource (file or folder) with a user given its username handled with argument \code{username}. 
  The \code{permissions} can be set among values 'read', 'update', 'create', 'delete', 'read-write', 'share', 
  'all'. By default the permissions will be the default permissions set by the ocs server (by default 'all').
  Returns the share properties as \code{list} (or as\code{data.frame} if \code{pretty} is set to TRUE).
 }
 \item{\code{shareWithGroup(path, name, group, permissions, pretty)}}{
  Shares a resource (file or folder) with a group given its name handled with argument \code{group}. 
  The \code{permissions} can be set among values 'read', 'update', 'create', 'delete', 'read-write', 'share', 
  'all'. By default the permissions will be the default permissions set by the ocs server (by default 'all').
  Returns the share properties as \code{list} (or as\code{data.frame} if \code{pretty} is set to TRUE).
 }
 \item{\code{shareAsPublicLink(path, name, publicUpload, password, permissions, expireDate)}}{
  Shares a resource (file or folder) as public link. The function returns the public link generated by ocs.
 }
}
}

\examples{
\dontrun{
   #Not Run:
   #Connect to an OCS API
   OCS <- ocsManager$new(url = ocs_url, user = ocs_user, pwd = ocs_pwd, logger = "DEBUG")
   version <- OCS$getVersion()
   caps <- OCS$getCapabilities()
   
   #OCS User Provisioning API
   #-------------------------------------
   #users
   users <- OCS$getUsers() #get users
   user <- OCS$getUser("admin") #get a user
   user.df <- OCS$getUser("admin", TRUE) #the same user as data.frame
   added <- OCS$addUser("john.doe", password = "ocs4john") #add a user
   disabled <- OCS$disableUser("john.doe") #disable a user
   enabled <- OCS$enableUser("john.doe") #enable auser
   edited <- OCS$editUser("john.doe", key = "display", value = "John Doe") #edit user
   #edit some user field
   edited2 <- OCS$editUserDisplayName("john.doe", displayName = "John Doe Jr.") 
   deleted <- OCS$deleteUser("john.doe")
   
   #groups
   admingroups <- OCS$getUserGroups("admin")
   groups <- OCS$getGroups()
   added <- OCS$addGroup("scientists") #add a new group
   sc_group <- OCS$getGroup("scientists") #get group details
   added <- OCS$addToGroup("john.doe", "scientists") #add user to group
   removed <- OCS$removeFromGroup("john.doe", "scientists") #remove user from group
   deleted <- OCS$deleteGroup("scientists")
   
   #OCS Webdav API
   #-------------------------------------
   #list files
   files <- OCS$listFiles()
   subfiles <- OCS$listFiles("Documents")
   #make collection
   OCS$makeCollection("myfolder")
   subfiles <- OCS$listFiles("myfolder")
   #upload a file?
   filename <- "magic.txt"
   file.create(filename); writeLines("ocs4R is great", filename)
   #we upload the file in 'Documents' folder
   OCS$uploadFile(filename, "/Documents")
   #check if file is uploaded
   OCS$listFiles('Documents')
   
   #OCS Sharing API
   #-------------------------------------
   #let's add a user with User provisioning API
   added <- OCS$addUser("john.doe", password = "ocs4john") #add a user
   #let's share the previously uploaded file with John Doe
   OCS$shareWithUser("/Documents", filename, "john.doe")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{manager}
\keyword{ocs}
