% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{binApply1D}
\alias{binApply1D}
\title{Apply a Function to Vector Data}
\usage{
binApply1D(x, f, xbreaks, FUN, include.lowest = FALSE, ...)
}
\arguments{
\item{x}{a vector of numerical values.}

\item{f}{a vector of data to which \code{FUN} will be applied.}

\item{xbreaks}{optional vector holding values of x at the boundaries between bins.
If this is not given, it is computed by calling \code{\link[=pretty]{pretty()}} with n=20 segments.}

\item{FUN}{function that is applied to the \code{f} values
in each x bin.  This must take a single numeric vector
as input, and return a single numeric value.}

\item{include.lowest}{logical value indicating whether to include
\code{x} values that equal \code{xbreaks[1]}.  See \dQuote{Details}.}

\item{\dots}{optional arguments to pass to \code{FUN}.}
}
\value{
A list with the following elements: \code{xbreaks} as
used, \code{xmids} (the mid-points between those breaks) and
\code{result} (the result of applying \code{FUN} to the \code{f} values
in the designated bins).
}
\description{
The function \code{FUN} is applied to \code{f} in bins specified by
\code{xbreaks}.  The division of data into bins is done with \code{\link[=cut]{cut()}}.
}
\details{
By default, the sub-intervals defined by the \code{xbreaks} argument are open
on the left and closed on the right, to match the behaviour
of \code{\link[=cut]{cut()}}.  An open interval does not include points on
the boundary, and so any \code{x} values that exactly match
the first \code{breaks} value will not be counted.  To include
such points in the calculation, set \code{include.lowest} to TRUE.
}
\examples{
library(oce)
# salinity profile (black) with 1-dbar bin means (red)
data(ctd)
plotProfile(ctd, "salinity")
p <- ctd[["pressure"]]
S <- ctd[["salinity"]]
pbreaks <- seq(0, max(p), 1)
binned <- binApply1D(p, S, pbreaks, mean)
lines(binned$result, binned$xmids, lwd = 2, col = rgb(1, 0, 0, 0.9))

}
\seealso{
Other bin-related functions: 
\code{\link{binApply2D}()},
\code{\link{binAverage}()},
\code{\link{binCount1D}()},
\code{\link{binCount2D}()},
\code{\link{binMean1D}()},
\code{\link{binMean2D}()}
}
\author{
Dan Kelley
}
\concept{bin-related functions}
