/* vim: set expandtab shiftwidth=2 softtabstop=2 tw=70: */

#include <Rcpp.h>
using namespace Rcpp;

// Cross-reference work:
// 1. update ../src/registerDynamicSymbol.c with an item for this
// 2. main code should use the autogenerated wrapper in ../R/RcppExports.R
//
// [[Rcpp::export]]
NumericVector do_get_bit(RawVector buf, int bit) // bit=0 for rightmost bit, =7 for leftmost bit
{
  static unsigned char mask[] = {1, 2, 4, 8, 16, 32, 64, 128};
  int n = buf.size();
  if (bit < 0)
    ::Rf_error("cannot have bit number less than 0; got %d", bit);
  if (bit > 7)
    ::Rf_error("cannot have bit number greater than 7; got %d", bit);
  NumericVector res(n);
  for (int i = 0; i < n; i++) {
    res[i] = (buf[i] & mask[bit]) != 0;
  }
  return(res);
}
