% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\name{download.amsr}
\alias{download.amsr}
\title{Download and Cache an amsr File}
\usage{
download.amsr(
  year,
  month,
  day,
  destdir = ".",
  server = "http://data.remss.com/amsr2/bmaps_v08"
)
}
\arguments{
\item{year, month, day}{Numerical values of the year, month, and day
of the desired dataset. Note that one file is archived per day,
so these three values uniquely identify a dataset.
If \code{day} and \code{month} are not provided but \code{day} is,
then the time is provided in a relative sense, based on the present
date, with \code{day} indicating the number of days in the past.
Owing to issues with timezones and the time when the data
are uploaded to the server, \code{day=3} may yield the
most recent available data. For this reason, there is a
third option, which is to leave \code{day} unspecified, which
works as though \code{day=3} had been given.}

\item{destdir}{A string naming the directory in which to cache the downloaded file.
The default is to store in the present directory, but many users find it more
helpful to use something like \code{"~/data/amsr"} for this, to collect all
downloaded amsr files in one place.}

\item{server}{A string naming the server from which data
are to be acquired. See \dQuote{History}.}
}
\value{
A character value indicating the filename of the result; if
there is a problem of any kind, the result will be the empty
string.
}
\description{
If the file is already present in \code{destdir}, then it is not
downloaded again. The default \code{destdir} is the present directory,
but it probably makes more sense to use something like \code{"~/data/amsr"}
to make it easy for scripts in other directories to use the cached data.
The file is downloaded with \code{\link[=download.file]{download.file()}}.
}
\section{History}{

Until 25 March 2017, the default server was
\code{"ftp.ssmi.com/amsr2/bmaps_v07.2"}, but this was changed when the author
discovered that this FTP site had been changed to require users to create
accounts to register for downloads.  The default was changed to
\code{"http://data.remss.com/amsr2/bmaps_v07.2"} on the named date.
This site was found by a web search, but it seems to provide proper data.
It is assumed that users will do some checking on the best source.

On 23 January 2018, it was noticed that the server-url naming convention
had changed, e.g.
\verb{http://data.remss.com/amsr2/bmaps_v07.2/y2017/m01/f34_20170114v7.2.gz}
becoming
\verb{http://data.remss.com/amsr2/bmaps_v08/y2017/m01/f34_20170114v8.gz}
}

\examples{
\dontrun{
## The download takes several seconds.
f <- download.amsr(2017, 1, 14) # Jan 14, 2017
d <- read.amsr(f)
plot(d)
mtext(d[["filename"]], side=3, line=0, adj=0)
}

}
\references{
\verb{http://images.remss.com/amsr/amsr2_data_daily.html}
provides daily images going back to 2012. Three-day,
monthly, and monthly composites are also provided on that site.
}
\seealso{
Other functions that download files: 
\code{\link{download.coastline}()},
\code{\link{download.met}()},
\code{\link{download.topo}()}

Other things related to amsr data: 
\code{\link{[[,amsr-method}},
\code{\link{[[<-,amsr-method}},
\code{\link{amsr-class}},
\code{\link{composite,amsr-method}},
\code{\link{plot,amsr-method}},
\code{\link{read.amsr}()},
\code{\link{subset,amsr-method}},
\code{\link{summary,amsr-method}}
}
\concept{functions that download files}
\concept{things related to amsr data}
