% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odf.R
\docType{methods}
\name{subset,odf-method}
\alias{subset,odf-method}
\title{Subset an ODF object}
\usage{
\S4method{subset}{odf}(x, subset, ...)
}
\arguments{
\item{x}{an \code{odf} object.}

\item{subset}{a condition to be applied to the \code{data} portion of
\code{x}.  See \sQuote{Details}.}

\item{\dots}{ignored.}
}
\value{
A new \code{odf} object.
}
\description{
This function is somewhat analogous to \code{\link{subset.data.frame}}.
}
\details{
It seems likely that users will first convert the odf object into
another class (e.g. ctd) and use the subset method of that class;
note that some of those methods interpret the \dots argument.
}
\seealso{
Other things related to \code{odf} data: \code{\link{ODF2oce}},
  \code{\link{ODFListFromHeader}},
  \code{\link{ODFNames2oceNames}},
  \code{\link{[[,odf-method}},
  \code{\link{[[<-,odf-method}}, \code{\link{odf-class}},
  \code{\link{plot,odf-method}},
  \code{\link{read.ctd.odf}}, \code{\link{read.odf}},
  \code{\link{summary,odf-method}}

Other functions that subset \code{oce} objects: \code{\link{subset,adp-method}},
  \code{\link{subset,adv-method}},
  \code{\link{subset,amsr-method}},
  \code{\link{subset,argo-method}},
  \code{\link{subset,cm-method}},
  \code{\link{subset,coastline-method}},
  \code{\link{subset,ctd-method}},
  \code{\link{subset,echosounder-method}},
  \code{\link{subset,lobo-method}},
  \code{\link{subset,met-method}},
  \code{\link{subset,oce-method}},
  \code{\link{subset,rsk-method}},
  \code{\link{subset,sealevel-method}},
  \code{\link{subset,section-method}},
  \code{\link{subset,topo-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset \code{oce} objects}
\concept{things related to \code{odf} data}
