% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swRho}
\alias{swRho}
\title{Seawater density}
\usage{
swRho(salinity, temperature = NULL, pressure = NULL, longitude = NULL,
  latitude = NULL, eos = getOption("oceEOS", default = "gsw"))
}
\arguments{
\item{salinity}{either practical salinity (in which case \code{temperature}
and \code{pressure} must be provided) \strong{or} an \code{oce} object, in
which case \code{salinity}, \code{temperature} (in the ITS-90 scale; see
next item), etc. are inferred from the object.}

\item{temperature}{\emph{in-situ} temperature [\eqn{^\circ}{deg}C], defined
on the ITS-90 scale.  This scale is used by GSW-style calculation (as
requested by setting \code{eos="gsw"}), and is the value contained within
\code{ctd} objects (and probably most other objects created with data
acquired in the past decade or two). Since the UNESCO-style calculation is
based on IPTS-68, the temperature is converted within the present function,
using \code{\link{T68fromT90}}.}

\item{pressure}{pressure [dbar]}

\item{longitude}{longitude of observation (only used if \code{eos="gsw"};
see \sQuote{Details}).}

\item{latitude}{latitude of observation (only used if \code{eos="gsw"}; see
\sQuote{Details}).}

\item{eos}{equation of state, either \code{"unesco"} [1,2] or \code{"gsw"}
[3,4].}
}
\value{
\emph{In-situ} density [kg/m\eqn{^3}{^3}].
}
\description{
Compute \eqn{\rho}{rho}, the \emph{in-situ} density of seawater.
}
\details{
If \code{eos="unesco"}, the density is calculated using the UNESCO equation
of state for seawater [1,2], and if \code{eos="gsw"}, the GSW formulation
[3,4] is used.
}
\section{Temperature units}{
 The UNESCO formulae are defined in terms of
temperature measured on the IPTS-68 scale, whereas the replacement GSW
formulae are based on the ITS-90 scale. Prior to the addition of GSW
capabilities, the various \code{sw*} functions took temperature to be in
IPTS-68 units. As GSW capabilities were added in early 2015, the assumed
unit of \code{temperature} was taken to be ITS-90.  This change means that
old code has to be modified, by replacing e.g. \code{swRho(S, T, p)} with
\code{swRho(S, T90fromT68(T), p)}. At typical oceanic values, the difference
between the two scales is a few millidegrees.
}

\examples{
library(oce)
# The numbers in the comments are the check values listed in reference [1];
# note that temperature in that reference was on the T68 scale, but that
# the present function works with the ITS-90 scale, so a conversion
# is required.
swRho(35, T90fromT68(5),      0, eos="unesco") # 1027.67547
swRho(35, T90fromT68(5),  10000, eos="unesco") # 1069.48914
swRho(35, T90fromT68(25),     0, eos="unesco") # 1023.34306
swRho(35, T90fromT68(25), 10000, eos="unesco") # 1062.53817

}
\references{
1. Fofonoff, P. and R. C. Millard Jr, 1983. Algorithms for computation of
fundamental properties of seawater. \emph{Unesco Technical Papers in Marine
Science}, \bold{44}, 53 pp

2. Gill, A.E., 1982. \emph{Atmosphere-ocean Dynamics}, Academic Press, New
York, 662 pp.

3. IOC, SCOR, and IAPSO (2010). The international thermodynamic equation of
seawater-2010: Calculation and use of thermodynamic properties.  Technical
Report 56, Intergovernmental Oceanographic Commission, Manuals and Guide.

4. McDougall, T.J. and P.M. Barker, 2011: Getting started with TEOS-10 and
the Gibbs Seawater (GSW) Oceanographic Toolbox, 28pp., SCOR/IAPSO WG127,
ISBN 978-0-646-55621-5.
}
\seealso{
Related density routines include \code{\link{swSigma0}} (and
equivalents at other pressure horizons), \code{\link{swSigmaT}}, and
\code{\link{swSigmaTheta}}.

Other functions that calculate seawater properties: \code{\link{T68fromT90}},
  \code{\link{T90fromT48}}, \code{\link{T90fromT68}},
  \code{\link{swAbsoluteSalinity}},
  \code{\link{swAlphaOverBeta}}, \code{\link{swAlpha}},
  \code{\link{swBeta}}, \code{\link{swCSTp}},
  \code{\link{swConservativeTemperature}},
  \code{\link{swDepth}}, \code{\link{swDynamicHeight}},
  \code{\link{swLapseRate}}, \code{\link{swN2}},
  \code{\link{swPressure}}, \code{\link{swRrho}},
  \code{\link{swSCTp}}, \code{\link{swSTrho}},
  \code{\link{swSigma0}}, \code{\link{swSigma1}},
  \code{\link{swSigma2}}, \code{\link{swSigma3}},
  \code{\link{swSigma4}}, \code{\link{swSigmaTheta}},
  \code{\link{swSigmaT}}, \code{\link{swSigma}},
  \code{\link{swSoundAbsorption}},
  \code{\link{swSoundSpeed}}, \code{\link{swSpecificHeat}},
  \code{\link{swSpice}}, \code{\link{swTFreeze}},
  \code{\link{swTSrho}},
  \code{\link{swThermalConductivity}},
  \code{\link{swTheta}}, \code{\link{swViscosity}},
  \code{\link{swZ}}
}
\author{
Dan Kelley
}
