% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{numberAsHMS}
\alias{numberAsHMS}
\title{Convert a Numeric Time to Hour, Minute, and Second}
\usage{
numberAsHMS(t, default = 0)
}
\arguments{
\item{t}{a vector of factors or character strings, in the format 1200 for
12:00, 0900 for 09:00, etc.}

\item{default}{value to be used for the returned hour, minute and second if
there is something wrong with the input value (e.g. its length exceeds 4
characters, or it contains non-numeric characters)}
}
\value{
A list containing \code{hour}, \code{minute}, and \code{second}, the
last of which is always zero.
}
\description{
Convert a Numeric Time to Hour, Minute, and Second
}
\examples{

t <- c("0900", "1234")
numberAsHMS(t)

}
\seealso{
Other things related to time: \code{\link{ctimeToSeconds}},
  \code{\link{julianCenturyAnomaly}},
  \code{\link{julianDay}}, \code{\link{numberAsPOSIXct}},
  \code{\link{secondsToCtime}},
  \code{\link{unabbreviateYear}}
}
\author{
Dan Kelley
}
