% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.R
\name{download.met}
\alias{download.met}
\title{Download and Cache a met File}
\usage{
download.met(id, year, month, deltat, destdir = "~/data/met", destfile,
  debug = getOption("oceDebug"))
}
\arguments{
\item{id}{A number giving the "Station ID" of the station of interest. If not
provided, \code{id} defaults to 6358, for Halifax International Airport. See
\dQuote{Details}.}

\item{year}{A number giving the year of interest. Ignored unless \code{deltat}
is \code{"hour"}. If \code{year} is not given, it defaults to the present year.}

\item{month}{A number giving the month of interest. Ignored unless \code{deltat}
is \code{"hour"}. If \code{month} is not given, it defaults to the present
month.}

\item{deltat}{Optional character string indicating the time step of the
desired dataset. This may be \code{"hour"} or \code{"month"}.
If \code{deltat} is not given, it defaults to \code{"hour"}.}

\item{destdir}{Optional string indicating the directory in which to store
downloaded files. If not supplied, \code{"."} is used, i.e. the data file
is stored in the present working directory.}

\item{destfile}{Optional string indicating the name of the file.
If not supplied, the file name is constructed from the other
parameters of the function call, so subsequent calls with the same
parameters will yield the same result, thus providing the key
to the caching scheme.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
String indicating the full pathname to the downloaded file.
}
\description{
Data are downloaded from \url{http://climate.weather.gc.ca} and cached locally.
}
\details{
The data are downloaded with \code{\link[utils]{download.file}}
pointed to the Environment Canada website [1]
using queries that had to be devised by reverse-engineering, since the agency
does not provide documentation about how to construct queries. Caution: the
query format changes from time to time, so \code{download.met} may work one
day, and fail the next.

The constructed query contains Station ID, as provided in the \code{id} argument.
Note that this seems to be a creation of Environment Canada, alone;
it is distinct from the more standard "Climate ID" and "WMO ID".
To make things more difficult, Environment Canada states that the
Station ID is subject to change over time. (Whether this applies to existing
data is unclear.)

Given these difficulties with Station ID, users are advised to consult
the Environment Canada website [1] before downloading any data,
and to check it from time to time
during the course of a research project, to see if the Station ID has changed.
Another approach would be to use Gavin Simpson's
\code{canadaHCD} package [2] to look up Station IDs. This package maintains
a copy of the Environment Canada listing of stations, and its
\code{find_station} function provides an easy way to determine Station IDs.
After that, its \code{hcd_hourly} function (and related functions) make
it easy to read data. These data can then be converted to the 
\code{met} class with \code{\link{as.met}}, although doing so leaves
many important metadata blank.
}
\section{Warning}{

All of the \code{download.*} functions are subject to change through the
year 2017. The plan is to create individual functions
as needs arise in everyday work, thereby discovering patterns of 
arguments that might make sense more generally. Therefore, it is likely
that argument order (and even name) may change up until approximately
December 2016. Users are advised to refer to arguments by name,
i.e. not to rely on their order, and they are asked for patience,
because argument names and defaults may vary through the early development.
}

\examples{
\dontrun{
library(oce)
## Download data for Halifax International Airport, in September
## of 2003. (This dataset is used for data(met) provided with oce.)
metFile <- download.met(6358, 2003, 9, destdir=".")
met <- read.met(metFile)
}

}
\references{
1. Environment Canada website for Historical Climate Data
\url{http://climate.weather.gc.ca/index_e.html}

2. Gavin Simpon's \code{canadaHCD} package on GitHub
\url{https://github.com/gavinsimpson/canadaHCD}
}
\seealso{
The work is done with \code{\link[utils]{download.file}}.

Other functions that download files: \code{\link{download.amsr}},
  \code{\link{download.coastline}},
  \code{\link{download.topo}}

Other things related to \code{met} data: \code{\link{[[,met-method}},
  \code{\link{[[<-,met-method}}, \code{\link{as.met}},
  \code{\link{met-class}}, \code{\link{met}},
  \code{\link{plot,met-method}}, \code{\link{read.met}},
  \code{\link{subset,met-method}},
  \code{\link{summary,met-method}}
}
\author{
Dan Kelley
}
