% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swAlpha}
\alias{swAlpha}
\title{Seawater thermal expansion coefficient}
\usage{
swAlpha(salinity, temperature = NULL, pressure = 0, longitude = 300,
  latitude = 30, eos = getOption("oceEOS", default = "gsw"))
}
\arguments{
\item{salinity}{either practical salinity (in which case \code{temperature}
and \code{pressure} must be provided) \strong{or} an \code{oce} object (in
which case \code{salinity}, etc. are inferred from the object).}

\item{temperature}{\emph{in-situ} temperature [\eqn{^\circ}{deg}C], defined
on the ITS-90 scale; see \dQuote{Temperature units} in the documentation for
\code{\link{swRho}}.}

\item{pressure}{pressure [dbar]}

\item{longitude}{longitude of observation (only used if \code{eos="gsw"};
see \sQuote{Details}).}

\item{latitude}{latitude of observation (only used if \code{eos="gsw"}; see
\sQuote{Details}).}

\item{eos}{equation of state, either \code{"unesco"} or \code{"gsw"}.}
}
\value{
Value in 1/degC.
}
\description{
Compute \eqn{\alpha}{alpha}, the thermal expansion coefficient for seawater.
}
\author{
Dan Kelley
}
\references{
The \code{eos="unesco"} formulae are based on the UNESCO
equation of state, but are formulated empirically by Trevor J. McDougall,
1987, Neutral Surfaces, Journal of Physical Oceanography, volume 17, pages
1950-1964. The \code{eos="gsw"} formulae come from GSW; see references in
the \code{\link{swRho}} documentation.
}
\seealso{
Other functions that calculate seawater properties: \code{\link{T68fromT90}},
  \code{\link{T90fromT48}}, \code{\link{T90fromT68}},
  \code{\link{swAbsoluteSalinity}},
  \code{\link{swAlphaOverBeta}}, \code{\link{swBeta}},
  \code{\link{swCSTp}},
  \code{\link{swConservativeTemperature}},
  \code{\link{swDepth}}, \code{\link{swDynamicHeight}},
  \code{\link{swLapseRate}}, \code{\link{swN2}},
  \code{\link{swPressure}}, \code{\link{swRho}},
  \code{\link{swRrho}}, \code{\link{swSCTp}},
  \code{\link{swSTrho}}, \code{\link{swSigma0}},
  \code{\link{swSigma1}}, \code{\link{swSigma2}},
  \code{\link{swSigma3}}, \code{\link{swSigma4}},
  \code{\link{swSigmaTheta}}, \code{\link{swSigmaT}},
  \code{\link{swSigma}}, \code{\link{swSoundAbsorption}},
  \code{\link{swSoundSpeed}}, \code{\link{swSpecificHeat}},
  \code{\link{swSpice}}, \code{\link{swTFreeze}},
  \code{\link{swTSrho}},
  \code{\link{swThermalConductivity}},
  \code{\link{swTheta}}, \code{\link{swViscosity}},
  \code{\link{swZ}}
}

