% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{binCount1D}
\alias{binCount1D}
\title{Bin-count vector data}
\usage{
binCount1D(x, xbreaks)
}
\arguments{
\item{x}{Vector of numerical values.}

\item{xbreaks}{Vector of values of x at the boundaries between bins, calculated using
\code{\link{pretty}} if not supplied.}
}
\value{
A list with the following elements: the breaks (\code{xbreaks},
midpoints (\code{xmids}) between those breaks, and
the count (\code{number}) of \code{x} values between successive breaks.
}
\description{
Count the number of elements of a given vector that fall within
successive pairs of values within a second vector.
}
\author{
Dan Kelley
}
\seealso{
Other bin-related functions: \code{\link{binApply1D}},
  \code{\link{binApply2D}}, \code{\link{binAverage}},
  \code{\link{binCount2D}}, \code{\link{binMean1D}},
  \code{\link{binMean2D}}
}

