% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\docType{methods}
\name{summary,ctd-method}
\alias{summary,ctd-method}
\title{Summarize a CTD Object}
\usage{
\S4method{summary}{ctd}(object, ...)
}
\arguments{
\item{object}{A \code{ctd} object, i.e. one inheriting from \code{\link{ctd-class}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
Summarizes some of the data in a \code{ctd} object, presenting such information
as the station name, sampling location, data ranges, etc. If the object was read
from a \code{.cnv} file or a \code{.rsk} file, then the \code{OriginalName}
column for the data summary will contain the original names of data within
the source file.
}
\examples{
library(oce)
data(ctd)
summary(ctd)

}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{ctd} data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctd-class}},
  \code{\link{ctdAddColumn}}, \code{\link{ctdDecimate}},
  \code{\link{ctdFindProfiles}}, \code{\link{ctdRaw}},
  \code{\link{ctdTrim}}, \code{\link{ctdUpdateHeader}},
  \code{\link{ctd}}, \code{\link{gps-class}},
  \code{\link{handleFlags,ctd-method}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotScan}}, \code{\link{plotTS}},
  \code{\link{read.ctd.itp}}, \code{\link{read.ctd.odf}},
  \code{\link{read.ctd.sbe}},
  \code{\link{read.ctd.woce.other}},
  \code{\link{read.ctd.woce}}, \code{\link{read.ctd}},
  \code{\link{subset,ctd-method}},
  \code{\link{woceNames2oceNames}}, \code{\link{write.ctd}}
}

