% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landsat.R
\docType{class}
\name{landsat-class}
\alias{landsat-class}
\title{Class to Hold landsat Data}
\description{
This class has the standard slots of an \code{\link{oce-class}}
object.  Landsat data are available at several websites (e.g. [1]).
Although the various functions may work for other satellites, the
discussion here focusses on Landsat 8 and Landsat 7.
}
\section{Data storage}{


The data are stored with 16-bit resolution.  Oce
breaks these 16 bits up into most-significant and least-significant bytes.
For example, the aerosol band of a Landsat object named \code{x} are
contained within \code{x@data$aerosol$msb} and \code{x@data$aerosol$lsb},
each of which is a matrix of raw values.  The results may be combined as e.g.
\preformatted{
256L*as.integer(x@data[[i]]$msb) + as.integer(x@data[[i]]$lsb)
}
and this is what is returned by executing \code{x[["aerosol"]]}.

Landsat data files typically occupy approximately a
gigabyte of storage.  That means that corresponding Oce objects are about
the same size, and this can pose significant problems on computers with
less than 8GB of memory.  It is sensible to specify bands of interest when
reading data with \code{\link{read.landsat}}, and also to use
\code{\link{landsatTrim}} to isolate geographical regions that need
processing.
    
Experts may need to get direct access to the data, and this is easy because
all Landsat objects (regardless of satellite) use a similar storage form.
Band information is stored in byte form, to conserve space.  Two bytes are
used for each pixel in Landsat-8 objects, with just one for other objects.
For example, if a Landsat-8 object named \code{L} contains the \code{tirs1}
band, the most- and least-significant bytes will be stored in matrices
\code{L@data$tirs1$msb} and \code{L@data$tirs1$lsb}.  A similar Landsat-7
object would have the same items, but \code{msb} would be just the value
\code{0x00}.  
    
Derived bands, which may be added to a landsat object with
\code{\link{landsatAdd}}, are not stored in byte matrices.  Instead they
are stored in numerical matrices, which means that they use 4X more storage
space for Landsat-8 images, and 8X more storage space for other satellites.
A computer needs at least 8GB of RAM to work with such data.
}

\section{Landsat 8}{


The Landsat 8 satellite has 11 frequency bands, listed below (see [2]).
\preformatted{
.------------------------------------------------------------------------------.
| Band | Band                      | Band         | Wavelength    | Resolution |
| No.  | Contents                  | Name         | (micrometers) |   (meters) |
|------+---------------------------+--------------+---------------+------------|
|    1 | Coastal aerosol           | aerosol      |  0.43 -  0.45 |         30 |
|    2 | Blue                      | blue         |  0.45 -  0.51 |         30 |
|    3 | Green                     | green        |  0.53 -  0.59 |         30 |
|    4 | Red                       | red          |  0.64 -  0.67 |         30 |
|    5 | Near Infrared (NIR)       | nir          |  0.85 -  0.88 |         30 |
|    6 | SWIR 1                    | swir1        |  1.57 -  1.65 |         30 |
|    7 | SWIR 2                    | swir2        |  2.11 -  2.29 |         30 |
|    8 | Panchromatic              | panchromatic |  0.50 -  0.68 |         15 |
|    9 | Cirrus                    | cirrus       |  1.36 -  1.38 |         30 |
|   10 | Thermal Infrared (TIRS) 1 | tirs1        | 10.60 - 11.19 |        100 |
|   11 | Thermal Infrared (TIRS) 2 | tirs2        | 11.50 - 12.51 |        100 |
.------------------------------------------------------------------------------.
}
In addition to the above, setting \code{band="terralook"} may be used as
an abbreviation for \code{band=c("red", "green", "nir")}.

Band 8 is panchromatic, and has the highest resolution.  For convenience of
programming, \code{\link{read.landsat}} subsamples the \code{tirs1} and
\code{tirs2} bands to the 30m resultion of the other bands.  See Reference
[3] for information about the evolution of Landsat 8 calibration
coefficients, which as of summer 2014 are still subject to change.
}

\section{Landsat 7}{


Band information is as follows (from [8]).  The names are not official, but
are set up to roughly correspond with Landsat-8 names, according to wavelength.
An exception is the Landsat-7 bands named \code{tirs1} and \code{tirs2}, which
are at two different gain settings, with identical wavelength span for
each, which roughly matches the range of the Landsat-8 bands \code{tirs1}
and \code{tirs2} combined.  This may seem confusing, but it lets code like
\code{plot(im, band="tirs1")} to work with both Landsat-8 and Landsat-7.

\preformatted{
.------------------------------------------------------------------------------.
| Band | Band                      | Band         | Wavelength    | Resolution |
| No.  | Contents                  | Name         | (micrometers) |   (meters) |
|------+---------------------------+--------------+---------------+------------|
|    1 | Blue                      | blue         |  0.45 -  0.52 |         30 |
|    2 | Green                     | green        |  0.52 -  0.60 |         30 |
|    3 | Red                       | red          |  0.63 -  0.69 |         30 |
|    4 | Near IR                   | nir          |  0.77 -  0.90 |         30 |
|    5 | SWIR                      | swir1        |  1.55 -  1.75 |         30 |
|    6 | Thermal IR                | tirs1        | 10.4  - 12.50 |         30 |
|    7 | Thermal IR                | tirs2        | 10.4  - 12.50 |         30 |
|    8 | SWIR                      | swir2        |  2.09 -  2.35 |         30 |
|    9 | Panchromatic              | panchromatic |  0.52 -  0.90 |         15 |
.------------------------------------------------------------------------------.
}
}
\author{
Dan Kelley and Clark Richards
}
\references{
1. See the USGS "glovis" web site.

2. see landsat.gsfc.nasa.gov/?page_id=5377

3. see landsat.usgs.gov/calibration_notices.php

4. \url{http://dankelley.github.io/r/2014/07/01/landsat.html}

5. \url{http://scienceofdoom.com/2010/12/27/emissivity-of-the-ocean/}

6. see landsat.usgs.gov/Landsat8_Using_Product.php

7. see landsathandbook.gsfc.nasa.gov/pdfs/Landsat7_Handbook.pdf

8. see landsat.usgs.gov/band_designations_landsat_satellites.php

9. Yu, X. X. Guo and Z. Wu., 2014. Land Surface Temperature Retrieval from
Landsat 8 TIRS-Comparison between Radiative Transfer Equation-Based Method,
Split Window Algorithm and Single Channel Method, \emph{Remote Sensing}, 6,
9829-9652.  \url{http://www.mdpi.com/2072-4292/6/10/9829}

10. Rajeshwari, A., and N. D. Mani, 2014.  Estimation of land surface
temperature of Dindigul district using Landsat 8 data.  \emph{International
    Journal of Research in Engineering and Technology}, 3(5), 122-126.
\url{http://www.academia.edu/7655089/ESTIMATION_OF_LAND_SURFACE_TEMPERATURE_OF_DINDIGUL_DISTRICT_USING_LANDSAT_8_DATA}

11. Konda, M. Imasato N., Nishi, K., and T. Toda, 1994.  Measurement of the Sea
Surface Emissivity.  \emph{Journal of Oceanography}, 50, 17:30.
\url{http://www.terrapub.co.jp/journals/JO/pdf/5001/50010017.pdf}
}
\seealso{
Data from AMSR satellites are handled with \code{\link{amsr-class}}.
    
A file containing Landsat data may be read with \code{\link{read.landsat}} or
\code{\link{read.oce}}, and one such file is provided by the \CRANpkg{ocedata}
package as a dataset named \code{landsat}.

Plots may be made with \code{\link{plot,landsat-method}}.  Since plotting can be quite
slow, decimation is available both in the plotting function and as the separate
function \code{\link{decimate}}.  Images may be subsetted with
\code{\link{landsatTrim}}.

\code{\link{landsat-class}} for handling data from the Landsat-8 satellite.

Other things related to \code{landsat} data: \code{\link{[[,landsat-method}},
  \code{\link{landsatAdd}}, \code{\link{landsatTrim}},
  \code{\link{landsat}}, \code{\link{plot,landsat-method}},
  \code{\link{read.landsat}},
  \code{\link{summary,landsat-method}}

Other things related to \code{landsat} data: \code{\link{[[,landsat-method}},
  \code{\link{landsatAdd}}, \code{\link{landsatTrim}},
  \code{\link{landsat}}, \code{\link{plot,landsat-method}},
  \code{\link{read.landsat}},
  \code{\link{summary,landsat-method}}
}
\concept{
satellite
}

