% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{api}
\alias{api}
\title{Start the occupation coding API.}
\usage{
api(
  start = TRUE,
  log_to_file = FALSE,
  file = system.file("plumber", "api", "plumber.R", package = "occupationMeasurement"),
  log_to_console = TRUE,
  log_filepath = file.path("output", "log_api.csv"),
  require_identifier = FALSE,
  allow_origin = NULL
)
}
\arguments{
\item{start}{Whether to immediately start the api. (Defaults to TRUE)}

\item{log_to_file}{Whether to requests should be logged in a file.
Defaults to FALSE.
Note: The file format used here is a CSV file for easier analysis.}

\item{file}{Path to the \code{plumber.R} file describing the API.
Defaults to \code{plumber/api/plumber.R} within the installed package.
Refer to this file to understand how the API is implemented.}

\item{log_to_console}{Whether to requests should be logged in the console.
Defaults to TRUE.}

\item{log_filepath}{The path to a CSV file in which to save the structured
logs.}

\item{require_identifier}{Whether an identifier has to be added to api
requests in order to match / identify requests afterwards.
Defaults to FALSE.}

\item{allow_origin}{Domain from which to allow cross origin requests (CORS).
If the API is running on a different domain / server than the application
using it, the website's root has to be provided here e.g.
"https://occupationMeasurement.github.io". For more information see the
\href{https://www.rplumber.io/articles/security.html#cross-origin-resource-sharing-cors}{plumber security page},
and \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin}{MDN}.
Defaults to NULL to not set any header at all.}
}
\value{
A Plumber router
}
\description{
Start the occupation coding API.
}
\examples{
\dontshow{data.table::setDTthreads(1)}

if (interactive()) {
  # Get the plumber router
  router <- api(
    start = FALSE,
    # If this is TRUE, the log directory will immediately be created
    log_to_file = FALSE
  )
  # Start the router
  plumber::pr_run(router)
}

if (interactive()) {
  # Immediately start the API
  api(start = TRUE)
}
}
\seealso{
\code{vignette("api")}
}
